/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.network;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.DefaultTenantNetwork;
import org.onosproject.vtnrsc.PhysicalNetwork;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;

@Command(scope="onos", name="tenantnetwork-update", description="Supports for updating a TenantNetwork")
public class TenantNetworkUpdateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="TenantNetwork network id", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="tenantID", description="The tenant id of TenantNetwork", required=true, multiValued=false)
    String tenantID = null;
    @Argument(index=2, name="type", description="The type of TenantNetwork", required=true, multiValued=false)
    String type = null;
    @Argument(index=3, name="segmentationID", description="The segmentation id of TenantNetwork", required=true, multiValued=false)
    String segmentationID = "";
    @Option(name="-n", aliases={"--name"}, description="TenantNetwork name", required=false, multiValued=false)
    String name = null;
    @Option(name="-a", aliases={"--adminStateUp"}, description="TenantNetwork adminStateUp is true or false", required=false, multiValued=false)
    boolean adminStateUp = false;
    @Option(name="-s", aliases={"--state"}, description="The state of TenantNetwork", required=false, multiValued=false)
    String state = null;
    @Option(name="-d", aliases={"--shared"}, description="TenantNetwork is shared or not", required=false, multiValued=false)
    boolean shared = false;
    @Option(name="-r", aliases={"--routerExternal"}, description="TenantNetwork is routerExternal or not", required=false, multiValued=false)
    boolean routerExternal = false;
    @Option(name="-p", aliases={"--physicalNetwork"}, description="The physical network of Tenant", required=false, multiValued=false)
    String physicalNetwork = "";

    protected void execute() {
        TenantNetworkService service = (TenantNetworkService)TenantNetworkUpdateCommand.get(TenantNetworkService.class);
        DefaultTenantNetwork network = new DefaultTenantNetwork(TenantNetworkId.networkId(this.id), this.name, this.adminStateUp, TenantNetwork.State.valueOf(this.state), this.shared, TenantId.tenantId(this.tenantID), this.routerExternal, TenantNetwork.Type.valueOf(this.type), PhysicalNetwork.physicalNetwork(this.physicalNetwork), SegmentationId.segmentationId(this.segmentationID));
        HashSet networksSet = Sets.newHashSet();
        networksSet.add(network);
        service.updateNetworks(networksSet);
    }
}

