/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.routerinterface;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;

@Command(scope="onos", name="routerinterface-create", description="Supports for creating a router interface")
public class RouterInterfaceCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="routerId", description="The router identifier of router interface", required=true, multiValued=false)
    String routerId = null;
    @Argument(index=1, name="tenantId", description="The tenant identifier of router interface", required=true, multiValued=false)
    String tenantId = null;
    @Argument(index=2, name="portId", description="The port identifier of router interface", required=true, multiValued=false)
    String portId = null;
    @Argument(index=3, name="subnetId", description="The subnet identifier of router interface", required=true, multiValued=false)
    String subnetId = null;

    protected void execute() {
        RouterInterfaceService service = (RouterInterfaceService)RouterInterfaceCreateCommand.get(RouterInterfaceService.class);
        try {
            RouterInterface routerInterface = RouterInterface.routerInterface(SubnetId.subnetId(this.subnetId), VirtualPortId.portId(this.portId), RouterId.valueOf(this.routerId), TenantId.tenantId(this.tenantId));
            service.addRouterInterface(routerInterface);
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

