/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.routerinterface;

import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;

@Command(scope="onos", name="routerinterface-remove", description="Supports for removing a router interface")
public class RouterInterfaceRemoveCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--subnetId"}, description="The subnet identifier of router interface", required=true, multiValued=false)
    String subnetId = null;

    protected void execute() {
        RouterInterfaceService service = (RouterInterfaceService)RouterInterfaceRemoveCommand.get(RouterInterfaceService.class);
        try {
            RouterInterface routerInterface = service.getRouterInterface(SubnetId.subnetId(this.subnetId));
            if (routerInterface == null) {
                this.print(null, new Object[]{"subnet ID of interface doesn't exist"});
                return;
            }
            service.removeRouterInterface(routerInterface);
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

