/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.flowclassifier.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierEvent;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierListener;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class FlowClassifierManager
extends AbstractListenerManager<FlowClassifierEvent, FlowClassifierListener>
implements FlowClassifierService {
    private static final String FLOW_CLASSIFIER_NOT_NULL = "Flow Classifier cannot be null";
    private static final String FLOW_CLASSIFIER_ID_NOT_NULL = "Flow Classifier Id cannot be null";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(FlowClassifierManager.class);
    private EventuallyConsistentMap<FlowClassifierId, FlowClassifier> flowClassifierStore;
    private EventuallyConsistentMapListener<FlowClassifierId, FlowClassifier> flowClassifierListener = new InnerFlowClassifierStoreListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    protected void activate() {
        this.eventDispatcher.addSink(FlowClassifierEvent.class, (EventSink)this.listenerRegistry);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{FlowClassifier.class});
        this.flowClassifierStore = this.storageService.eventuallyConsistentMapBuilder().withName("flowclassifierstore").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.flowClassifierStore.addListener(this.flowClassifierListener);
        this.log.info("Flow Classifier service activated");
    }

    @Deactivate
    protected void deactivate() {
        this.eventDispatcher.removeSink(FlowClassifierEvent.class);
        this.flowClassifierStore.destroy();
        this.log.info("Flow Classifier service deactivated");
    }

    @Override
    public boolean exists(FlowClassifierId id) {
        Preconditions.checkNotNull((Object)((Object)id), (Object)FLOW_CLASSIFIER_ID_NOT_NULL);
        return this.flowClassifierStore.containsKey((Object)id);
    }

    @Override
    public int getFlowClassifierCount() {
        return this.flowClassifierStore.size();
    }

    @Override
    public Iterable<FlowClassifier> getFlowClassifiers() {
        return ImmutableList.copyOf((Collection)this.flowClassifierStore.values());
    }

    @Override
    public FlowClassifier getFlowClassifier(FlowClassifierId id) {
        Preconditions.checkNotNull((Object)((Object)id), (Object)FLOW_CLASSIFIER_ID_NOT_NULL);
        return (FlowClassifier)this.flowClassifierStore.get((Object)id);
    }

    @Override
    public boolean createFlowClassifier(FlowClassifier flowClassifier) {
        this.log.debug("createFlowClassifier");
        Preconditions.checkNotNull((Object)flowClassifier, (Object)FLOW_CLASSIFIER_NOT_NULL);
        FlowClassifierId id = flowClassifier.flowClassifierId();
        this.flowClassifierStore.put((Object)id, (Object)flowClassifier);
        if (!this.flowClassifierStore.containsKey((Object)id)) {
            this.log.debug("Flow Classifier creation is failed whose identifier is {}.", (Object)id.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updateFlowClassifier(FlowClassifier flowClassifier) {
        Preconditions.checkNotNull((Object)flowClassifier, (Object)FLOW_CLASSIFIER_NOT_NULL);
        if (!this.flowClassifierStore.containsKey((Object)flowClassifier.flowClassifierId())) {
            this.log.debug("The flowClassifier is not exist whose identifier was {} ", (Object)flowClassifier.flowClassifierId().toString());
            return false;
        }
        this.flowClassifierStore.put((Object)flowClassifier.flowClassifierId(), (Object)flowClassifier);
        if (!flowClassifier.equals(this.flowClassifierStore.get((Object)flowClassifier.flowClassifierId()))) {
            this.log.debug("Updation of flowClassifier is failed whose identifier was {} ", (Object)flowClassifier.flowClassifierId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeFlowClassifier(FlowClassifierId id) {
        Preconditions.checkNotNull((Object)((Object)id), (Object)FLOW_CLASSIFIER_ID_NOT_NULL);
        this.flowClassifierStore.remove((Object)id);
        if (this.flowClassifierStore.containsKey((Object)id)) {
            this.log.debug("The Flow Classifier removal is failed whose identifier is {}", (Object)id.toString());
            return false;
        }
        return true;
    }

    private void notifyListeners(FlowClassifierEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InnerFlowClassifierStoreListener
    implements EventuallyConsistentMapListener<FlowClassifierId, FlowClassifier> {
        private InnerFlowClassifierStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<FlowClassifierId, FlowClassifier> event) {
            Preconditions.checkNotNull(event, (Object)FlowClassifierManager.EVENT_NOT_NULL);
            FlowClassifier flowClassifier = (FlowClassifier)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                FlowClassifierManager.this.notifyListeners(new FlowClassifierEvent(FlowClassifierEvent.Type.FLOW_CLASSIFIER_PUT, flowClassifier));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                FlowClassifierManager.this.notifyListeners(new FlowClassifierEvent(FlowClassifierEvent.Type.FLOW_CLASSIFIER_DELETE, flowClassifier));
            }
        }
    }
}

