/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.portpair.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.portpair.PortPairEvent;
import org.onosproject.vtnrsc.portpair.PortPairListener;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PortPairManager
extends AbstractListenerManager<PortPairEvent, PortPairListener>
implements PortPairService {
    private static final String PORT_PAIR_ID_NULL = "PortPair ID cannot be null";
    private static final String PORT_PAIR_NULL = "PortPair cannot be null";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EventuallyConsistentMap<PortPairId, PortPair> portPairStore;
    private EventuallyConsistentMapListener<PortPairId, PortPair> portPairListener = new InnerPortPairStoreListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(PortPairEvent.class, (EventSink)this.listenerRegistry);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{PortPair.class});
        this.portPairStore = this.storageService.eventuallyConsistentMapBuilder().withName("portpairstore").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.portPairStore.addListener(this.portPairListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(PortPairEvent.class);
        this.portPairStore.destroy();
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(PortPairId portPairId) {
        Preconditions.checkNotNull((Object)((Object)portPairId), (Object)PORT_PAIR_ID_NULL);
        return this.portPairStore.containsKey((Object)portPairId);
    }

    @Override
    public int getPortPairCount() {
        return this.portPairStore.size();
    }

    @Override
    public Iterable<PortPair> getPortPairs() {
        return Collections.unmodifiableCollection(this.portPairStore.values());
    }

    @Override
    public PortPair getPortPair(PortPairId portPairId) {
        Preconditions.checkNotNull((Object)((Object)portPairId), (Object)PORT_PAIR_ID_NULL);
        return (PortPair)this.portPairStore.get((Object)portPairId);
    }

    @Override
    public boolean createPortPair(PortPair portPair) {
        Preconditions.checkNotNull((Object)portPair, (Object)PORT_PAIR_NULL);
        this.portPairStore.put((Object)portPair.portPairId(), (Object)portPair);
        if (!this.portPairStore.containsKey((Object)portPair.portPairId())) {
            this.log.debug("The portPair is created failed which identifier was {}", (Object)portPair.portPairId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updatePortPair(PortPair portPair) {
        Preconditions.checkNotNull((Object)portPair, (Object)PORT_PAIR_NULL);
        if (!this.portPairStore.containsKey((Object)portPair.portPairId())) {
            this.log.debug("The portPair is not exist whose identifier was {} ", (Object)portPair.portPairId().toString());
            return false;
        }
        this.portPairStore.put((Object)portPair.portPairId(), (Object)portPair);
        if (!portPair.equals(this.portPairStore.get((Object)portPair.portPairId()))) {
            this.log.debug("The portPair is updated failed whose identifier was {} ", (Object)portPair.portPairId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removePortPair(PortPairId portPairId) {
        Preconditions.checkNotNull((Object)((Object)portPairId), (Object)PORT_PAIR_NULL);
        this.portPairStore.remove((Object)portPairId);
        if (this.portPairStore.containsKey((Object)portPairId)) {
            this.log.debug("The portPair is removed failed whose identifier was {}", (Object)portPairId.toString());
            return false;
        }
        return true;
    }

    private void notifyListeners(PortPairEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InnerPortPairStoreListener
    implements EventuallyConsistentMapListener<PortPairId, PortPair> {
        private InnerPortPairStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<PortPairId, PortPair> event) {
            Preconditions.checkNotNull(event, (Object)PortPairManager.EVENT_NOT_NULL);
            PortPair portPair = (PortPair)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                PortPairManager.this.notifyListeners(new PortPairEvent(PortPairEvent.Type.PORT_PAIR_PUT, portPair));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                PortPairManager.this.notifyListeners(new PortPairEvent(PortPairEvent.Type.PORT_PAIR_DELETE, portPair));
            }
        }
    }
}

