/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.portpairgroup.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupEvent;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupListener;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PortPairGroupManager
extends AbstractListenerManager<PortPairGroupEvent, PortPairGroupListener>
implements PortPairGroupService {
    private static final String PORT_PAIR_GROUP_ID_NULL = "PortPairGroup ID cannot be null";
    private static final String PORT_PAIR_GROUP_NULL = "PortPairGroup cannot be null";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EventuallyConsistentMap<PortPairGroupId, PortPairGroup> portPairGroupStore;
    private EventuallyConsistentMapListener<PortPairGroupId, PortPairGroup> portPairGroupListener = new InnerPortPairGroupStoreListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(PortPairGroupEvent.class, (EventSink)this.listenerRegistry);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{PortPairGroup.class});
        this.portPairGroupStore = this.storageService.eventuallyConsistentMapBuilder().withName("portpairgroupstore").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.portPairGroupStore.addListener(this.portPairGroupListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(PortPairGroupEvent.class);
        this.portPairGroupStore.destroy();
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(PortPairGroupId portPairGroupId) {
        Preconditions.checkNotNull((Object)((Object)portPairGroupId), (Object)PORT_PAIR_GROUP_ID_NULL);
        return this.portPairGroupStore.containsKey((Object)portPairGroupId);
    }

    @Override
    public int getPortPairGroupCount() {
        return this.portPairGroupStore.size();
    }

    @Override
    public Iterable<PortPairGroup> getPortPairGroups() {
        return Collections.unmodifiableCollection(this.portPairGroupStore.values());
    }

    @Override
    public PortPairGroup getPortPairGroup(PortPairGroupId portPairGroupId) {
        Preconditions.checkNotNull((Object)((Object)portPairGroupId), (Object)PORT_PAIR_GROUP_ID_NULL);
        return (PortPairGroup)this.portPairGroupStore.get((Object)portPairGroupId);
    }

    @Override
    public boolean createPortPairGroup(PortPairGroup portPairGroup) {
        Preconditions.checkNotNull((Object)portPairGroup, (Object)PORT_PAIR_GROUP_NULL);
        this.portPairGroupStore.put((Object)portPairGroup.portPairGroupId(), (Object)portPairGroup);
        if (!this.portPairGroupStore.containsKey((Object)portPairGroup.portPairGroupId())) {
            this.log.debug("The portPairGroup is created failed which identifier was {}", (Object)portPairGroup.portPairGroupId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updatePortPairGroup(PortPairGroup portPairGroup) {
        Preconditions.checkNotNull((Object)portPairGroup, (Object)PORT_PAIR_GROUP_NULL);
        if (!this.portPairGroupStore.containsKey((Object)portPairGroup.portPairGroupId())) {
            this.log.debug("The portPairGroup is not exist whose identifier was {} ", (Object)portPairGroup.portPairGroupId().toString());
            return false;
        }
        this.portPairGroupStore.put((Object)portPairGroup.portPairGroupId(), (Object)portPairGroup);
        if (!portPairGroup.equals(this.portPairGroupStore.get((Object)portPairGroup.portPairGroupId()))) {
            this.log.debug("The portPairGroup is updated failed whose identifier was {} ", (Object)portPairGroup.portPairGroupId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removePortPairGroup(PortPairGroupId portPairGroupId) {
        Preconditions.checkNotNull((Object)((Object)portPairGroupId), (Object)PORT_PAIR_GROUP_NULL);
        this.portPairGroupStore.remove((Object)portPairGroupId);
        if (this.portPairGroupStore.containsKey((Object)portPairGroupId)) {
            this.log.debug("The portPairGroup is removed failed whose identifier was {}", (Object)portPairGroupId.toString());
            return false;
        }
        return true;
    }

    private void notifyListeners(PortPairGroupEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InnerPortPairGroupStoreListener
    implements EventuallyConsistentMapListener<PortPairGroupId, PortPairGroup> {
        private InnerPortPairGroupStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<PortPairGroupId, PortPairGroup> event) {
            Preconditions.checkNotNull(event, (Object)PortPairGroupManager.EVENT_NOT_NULL);
            PortPairGroup portPairGroup = (PortPairGroup)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                PortPairGroupManager.this.notifyListeners(new PortPairGroupEvent(PortPairGroupEvent.Type.PORT_PAIR_GROUP_PUT, portPairGroup));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                PortPairGroupManager.this.notifyListeners(new PortPairGroupEvent(PortPairGroupEvent.Type.PORT_PAIR_GROUP_DELETE, portPairGroup));
            }
        }
    }
}

