/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.virtualport.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.SecurityGroup;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VirtualPortManager
implements VirtualPortService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VIRTUALPORT = "vtn-virtual-port";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private static final String VIRTUALPORT_ID_NULL = "VirtualPort ID cannot be null";
    private static final String VIRTUALPORT_NOT_NULL = "VirtualPort  cannot be null";
    private static final String TENANTID_NOT_NULL = "TenantId  cannot be null";
    private static final String NETWORKID_NOT_NULL = "NetworkId  cannot be null";
    private static final String DEVICEID_NOT_NULL = "DeviceId  cannot be null";
    private static final String FIXEDIP_NOT_NULL = "FixedIp  cannot be null";
    private static final String IP_NOT_NULL = "Ip  cannot be null";
    protected Map<VirtualPortId, VirtualPort> vPortStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService networkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        this.vPortStore = ((ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(VIRTUALPORT)).withApplicationId(this.appId)).withPurgeOnUninstall().withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{VirtualPortId.class, TenantNetworkId.class, VirtualPort.State.class, TenantId.class, AllowedAddressPair.class, FixedIp.class, BindingHostId.class, SecurityGroup.class, SubnetId.class, IpAddress.class, DefaultVirtualPort.class}))).build()).asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.vPortStore.clear();
        this.log.info("Stoppped");
    }

    @Override
    public boolean exists(VirtualPortId vPortId) {
        Preconditions.checkNotNull((Object)((Object)vPortId), (Object)VIRTUALPORT_ID_NULL);
        return this.vPortStore.containsKey((Object)vPortId);
    }

    @Override
    public VirtualPort getPort(VirtualPortId vPortId) {
        Preconditions.checkNotNull((Object)((Object)vPortId), (Object)VIRTUALPORT_ID_NULL);
        return this.vPortStore.get((Object)vPortId);
    }

    @Override
    public VirtualPort getPort(FixedIp fixedIP) {
        Preconditions.checkNotNull((Object)fixedIP, (Object)FIXEDIP_NOT_NULL);
        ArrayList vPorts = new ArrayList();
        this.vPortStore.values().stream().forEach(p -> {
            Iterator<FixedIp> fixedIps = p.fixedIps().iterator();
            while (fixedIps.hasNext()) {
                if (!fixedIps.next().equals(fixedIP)) continue;
                vPorts.add(p);
                break;
            }
        });
        if (vPorts.size() == 0) {
            return null;
        }
        return (VirtualPort)vPorts.get(0);
    }

    @Override
    public VirtualPort getPort(TenantNetworkId networkId, IpAddress ip) {
        Preconditions.checkNotNull((Object)((Object)networkId), (Object)NETWORKID_NOT_NULL);
        Preconditions.checkNotNull((Object)ip, (Object)IP_NOT_NULL);
        ArrayList vPorts = new ArrayList();
        this.vPortStore.values().stream().filter(p -> p.networkId().equals((Object)networkId)).forEach(p -> {
            Iterator<FixedIp> fixedIps = p.fixedIps().iterator();
            while (fixedIps.hasNext()) {
                if (!fixedIps.next().ip().equals((Object)ip)) continue;
                vPorts.add(p);
                break;
            }
        });
        if (vPorts.size() == 0) {
            return null;
        }
        return (VirtualPort)vPorts.get(0);
    }

    @Override
    public Collection<VirtualPort> getPorts() {
        return Collections.unmodifiableCollection(this.vPortStore.values());
    }

    @Override
    public Collection<VirtualPort> getPorts(TenantNetworkId networkId) {
        Preconditions.checkNotNull((Object)((Object)networkId), (Object)NETWORKID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.networkId().equals((Object)networkId)).collect(Collectors.toList());
    }

    @Override
    public Collection<VirtualPort> getPorts(TenantId tenantId) {
        Preconditions.checkNotNull((Object)((Object)tenantId), (Object)TENANTID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.tenantId().equals((Object)tenantId)).collect(Collectors.toList());
    }

    @Override
    public Collection<VirtualPort> getPorts(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICEID_NOT_NULL);
        return this.vPortStore.values().stream().filter(d -> d.deviceId().equals((Object)deviceId)).collect(Collectors.toList());
    }

    @Override
    public boolean createPorts(Iterable<VirtualPort> vPorts) {
        Preconditions.checkNotNull(vPorts, (Object)VIRTUALPORT_NOT_NULL);
        for (VirtualPort vPort : vPorts) {
            this.log.debug("vPortId is  {} ", (Object)vPort.portId().toString());
            this.vPortStore.put(vPort.portId(), vPort);
            if (this.vPortStore.containsKey((Object)vPort.portId())) continue;
            this.log.debug("The virtualPort is created failed whose identifier is {} ", (Object)vPort.portId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updatePorts(Iterable<VirtualPort> vPorts) {
        Preconditions.checkNotNull(vPorts, (Object)VIRTUALPORT_NOT_NULL);
        for (VirtualPort vPort : vPorts) {
            this.vPortStore.put(vPort.portId(), vPort);
            if (!this.vPortStore.containsKey((Object)vPort.portId())) {
                this.log.debug("The virtualPort is not exist whose identifier is {}", (Object)vPort.portId().toString());
                return false;
            }
            this.vPortStore.put(vPort.portId(), vPort);
            if (vPort.equals(this.vPortStore.get((Object)vPort.portId()))) continue;
            this.log.debug("The virtualPort is updated failed whose  identifier is {}", (Object)vPort.portId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removePorts(Iterable<VirtualPortId> vPortIds) {
        Preconditions.checkNotNull(vPortIds, (Object)VIRTUALPORT_ID_NULL);
        for (VirtualPortId vPortId : vPortIds) {
            this.vPortStore.remove((Object)vPortId);
            if (!this.vPortStore.containsKey((Object)vPortId)) continue;
            this.log.debug("The virtualPort is removed failed whose identifier is {}", (Object)vPortId.toString());
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindNetworkService(TenantNetworkService tenantNetworkService) {
        this.networkService = tenantNetworkService;
    }

    protected void unbindNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.networkService == tenantNetworkService) {
            this.networkService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

