/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.api.client.WebResource;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.vtnrsc.classifier.ClassifierService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class ClassifierResourceTest
extends VtnResourceTest {
    final ClassifierService classifierService = (ClassifierService)EasyMock.createMock(ClassifierService.class);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ClassifierService.class, (Object)this.classifierService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testClassifiersEmpty() {
        EasyMock.expect((Object)this.classifierService.getClassifiers()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.classifierService});
        WebResource rs = this.resource();
        String response = (String)rs.path("classifiers").get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"classifiers\":[]}"));
    }

    @Test
    public void testClassifiers() {
        DeviceId devId1 = NetTestTools.did((String)"dev1");
        Device device1 = NetTestTools.device((String)"dev1");
        EasyMock.expect((Object)this.classifierService.getClassifiers()).andReturn((Object)ImmutableList.of((Object)devId1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.classifierService});
        WebResource rs = this.resource();
        String response = (String)rs.path("classifiers").get(String.class);
        JsonObject result = JsonObject.readFrom((String)response);
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }
}

