/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.JsonObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortChainResourceTest
extends VtnResourceTest {
    final PortChainService portChainService = (PortChainService)EasyMock.createMock(PortChainService.class);
    PortChainId portChainId1 = PortChainId.of((String)"78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae");
    TenantId tenantId1 = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
    private final List<PortPairGroupId> portPairGroupList1 = Lists.newArrayList();
    private final List<FlowClassifierId> flowClassifierList1 = Lists.newArrayList();
    final MockPortChain portChain1 = new MockPortChain(this.portChainId1, this.tenantId1, "portChain1", "Mock port chain", this.portPairGroupList1, this.flowClassifierList1);

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PortChainService.class, (Object)this.portChainService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testPortChainsEmpty() {
        EasyMock.expect((Object)this.portChainService.getPortChains()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebResource rs = this.resource();
        String response = (String)rs.path("port_chains").get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"port_chains\":[]}"));
    }

    @Test
    public void testGetPortChainId() {
        HashSet<MockPortChain> portChains = new HashSet<MockPortChain>();
        portChains.add(this.portChain1);
        EasyMock.expect((Object)this.portChainService.exists((PortChainId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.portChainService.getPortChain((PortChainId)EasyMock.anyObject())).andReturn((Object)this.portChain1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebResource rs = this.resource();
        String response = (String)rs.path("port_chains/1278dcd4-459f-62ed-754b-87fc5e4a6751").get(String.class);
        JsonObject result = JsonObject.readFrom((String)response);
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.portChainService.getPortChain((PortChainId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebResource rs = this.resource();
        try {
            rs.path("port_chains/78dcd363-fc23-aeb6-f44b-56dc5aafb3ae").get(String.class);
            Assert.fail((String)"Fetch of non-existent port chain did not throw an exception");
        }
        catch (UniformInterfaceException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"returned a response status of"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.portChainService.createPortChain((PortChain)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebResource rs = this.resource();
        InputStream jsonStream = PortChainResourceTest.class.getResourceAsStream("post-PortChain.json");
        ClientResponse response = (ClientResponse)rs.path("port_chains").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)jsonStream);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.portChainService.removePortChain((PortChainId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portChainService});
        WebResource rs = this.resource();
        String location = "port_chains/1278dcd4-459f-62ed-754b-87fc5e4a6751";
        ClientResponse deleteResponse = (ClientResponse)rs.path(location).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private static class MockPortChain
    implements PortChain {
        private final PortChainId portChainId;
        private final TenantId tenantId;
        private final String name;
        private final String description;
        private final List<PortPairGroupId> portPairGroupList;
        private final List<FlowClassifierId> flowClassifierList;

        public MockPortChain(PortChainId portChainId, TenantId tenantId, String name, String description, List<PortPairGroupId> portPairGroupList, List<FlowClassifierId> flowClassifierList) {
            this.portChainId = portChainId;
            this.tenantId = tenantId;
            this.name = name;
            this.description = description;
            this.portPairGroupList = portPairGroupList;
            this.flowClassifierList = flowClassifierList;
        }

        public PortChainId portChainId() {
            return this.portChainId;
        }

        public TenantId tenantId() {
            return this.tenantId;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public List<PortPairGroupId> portPairGroups() {
            return ImmutableList.copyOf(this.portPairGroupList);
        }

        public List<FlowClassifierId> flowClassifiers() {
            return ImmutableList.copyOf(this.flowClassifierList);
        }

        public boolean exactMatch(PortChain portChain) {
            return this.equals(portChain) && Objects.equals(this.portChainId, portChain.portChainId()) && Objects.equals(this.tenantId, portChain.tenantId());
        }
    }
}

