/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.eclipsesource.json.JsonObject;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnweb.resources.VtnResourceTest;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortPairResourceTest
extends VtnResourceTest {
    final PortPairService portPairService = (PortPairService)EasyMock.createMock(PortPairService.class);
    PortPairId portPairId1 = PortPairId.of((String)"78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae");
    TenantId tenantId1 = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
    final MockPortPair portPair1 = new MockPortPair(this.portPairId1, this.tenantId1, "portPair1", "Mock port pair", "dace4513-24fc-4fae-af4b-321c5e2eb3d1", "aef3478a-4a56-2a6e-cd3a-9dee4e2ec345");

    @Before
    public void setUpTest() {
        SfcCodecContext context = new SfcCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PortPairService.class, (Object)this.portPairService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testPortPairsEmpty() {
        EasyMock.expect((Object)this.portPairService.getPortPairs()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairService});
        WebResource rs = this.resource();
        String response = (String)rs.path("port_pairs").get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"port_pairs\":[]}"));
    }

    @Test
    public void testGetPortPairId() {
        HashSet<MockPortPair> portPairs = new HashSet<MockPortPair>();
        portPairs.add(this.portPair1);
        EasyMock.expect((Object)this.portPairService.exists((PortPairId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.portPairService.getPortPair((PortPairId)EasyMock.anyObject())).andReturn((Object)this.portPair1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairService});
        WebResource rs = this.resource();
        String response = (String)rs.path("port_pairs/78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae").get(String.class);
        JsonObject result = JsonObject.readFrom((String)response);
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.portPairService.getPortPair((PortPairId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairService});
        WebResource rs = this.resource();
        try {
            rs.path("port_pairs/78dcd363-fc23-aeb6-f44b-56dc5aafb3ae").get(String.class);
            Assert.fail((String)"Fetch of non-existent port pair did not throw an exception");
        }
        catch (UniformInterfaceException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"returned a response status of"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.portPairService.createPortPair((PortPair)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairService});
        WebResource rs = this.resource();
        InputStream jsonStream = PortPairResourceTest.class.getResourceAsStream("post-PortPair.json");
        ClientResponse response = (ClientResponse)rs.path("port_pairs").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)jsonStream);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.portPairService.removePortPair((PortPairId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.portPairService});
        WebResource rs = this.resource();
        String location = "port_pairs/78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae";
        ClientResponse deleteResponse = (ClientResponse)rs.path(location).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    private static class MockPortPair
    implements PortPair {
        private final PortPairId portPairId;
        private final TenantId tenantId;
        private final String name;
        private final String description;
        private final String ingress;
        private final String egress;

        public MockPortPair(PortPairId portPairId, TenantId tenantId, String name, String description, String ingress, String egress) {
            this.portPairId = portPairId;
            this.tenantId = tenantId;
            this.name = name;
            this.description = description;
            this.ingress = ingress;
            this.egress = egress;
        }

        public PortPairId portPairId() {
            return this.portPairId;
        }

        public TenantId tenantId() {
            return this.tenantId;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public String ingress() {
            return this.ingress;
        }

        public String egress() {
            return this.egress;
        }

        public boolean exactMatch(PortPair portPair) {
            return this.equals(portPair) && Objects.equals(this.portPairId, portPair.portPairId()) && Objects.equals(this.tenantId, portPair.tenantId());
        }
    }
}

