/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortPairCodecTest {
    SfcCodecContext context;
    JsonCodec<PortPair> portPairCodec;

    @Before
    public void setUp() {
        this.context = new SfcCodecContext();
        this.portPairCodec = this.context.codec(PortPair.class);
        MatcherAssert.assertThat(this.portPairCodec, (Matcher)Matchers.notNullValue());
    }

    private PortPair getPortPair(String resourceName) throws IOException {
        InputStream jsonStream = PortPairCodecTest.class.getResourceAsStream(resourceName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        PortPair portPair = (PortPair)this.portPairCodec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)portPair, (Matcher)Matchers.notNullValue());
        return portPair;
    }

    @Test
    public void codecPortPairTest() throws IOException {
        PortPair portPair = this.getPortPair("portPair.json");
        MatcherAssert.assertThat((Object)portPair, (Matcher)Matchers.notNullValue());
        PortPairId portPairId = PortPairId.of((String)"78dcd363-fc23-aeb6-f44b-56dc5e2fb3ae");
        TenantId tenantId = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
        MatcherAssert.assertThat((Object)portPair.portPairId().toString(), (Matcher)Matchers.is((Object)portPairId.toString()));
        MatcherAssert.assertThat((Object)portPair.name(), (Matcher)Matchers.is((Object)"PP1"));
        MatcherAssert.assertThat((Object)portPair.tenantId().toString(), (Matcher)Matchers.is((Object)tenantId.toString()));
        MatcherAssert.assertThat((Object)portPair.description(), (Matcher)Matchers.is((Object)"SF-A"));
        MatcherAssert.assertThat((Object)portPair.ingress().toString(), (Matcher)Matchers.is((Object)"dace4513-24fc-4fae-af4b-321c5e2eb3d1"));
        MatcherAssert.assertThat((Object)portPair.egress().toString(), (Matcher)Matchers.is((Object)"aef3478a-4a56-2a6e-cd3a-9dee4e2ec345"));
    }
}

