/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.DefaultTenantNetwork;
import org.onosproject.vtnrsc.PhysicalNetwork;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnweb.web.TenantNetworkCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="networks")
public class TenantNetworkWebResource
extends AbstractWebResource {
    public static final String NETWORK_NOT_FOUND = "Network is not found";
    public static final String NETWORK_ID_EXIST = "Network id is existed";
    public static final String NETWORK_ID_NOT_EXIST = "Network id is not existed";
    public static final String CREATE_NETWORK = "create network";
    public static final String UPDATE_NETWORK = "update network";
    public static final String DELETE_NETWORK = "delete network";
    public static final String JSON_NOT_NULL = "JsonNode can not be null";
    protected static final Logger log = LoggerFactory.getLogger(TenantNetworkWebResource.class);
    private final ConcurrentMap<TenantNetworkId, TenantNetwork> networksMap = Maps.newConcurrentMap();

    @GET
    @Produces(value={"application/json"})
    public Response getNetworks(@QueryParam(value="id") String queryId, @QueryParam(value="name") String queryName, @QueryParam(value="admin_state_up") String queryadminStateUp, @QueryParam(value="status") String querystate, @QueryParam(value="shared") String queryshared, @QueryParam(value="tenant_id") String querytenantId, @QueryParam(value="router:external") String routerExternal, @QueryParam(value="provider:network_type") String type, @QueryParam(value="provider:physical_network") String physicalNetwork, @QueryParam(value="provider:segmentation_id") String segmentationId) {
        Collection<TenantNetwork> networks = ((TenantNetworkService)this.get(TenantNetworkService.class)).getNetworks();
        for (TenantNetwork network : networks) {
            if (queryId != null && !queryId.equals(network.id().toString()) || queryName != null && !queryName.equals(network.name()) || queryadminStateUp != null && !queryadminStateUp.equals(Boolean.toString(network.adminStateUp())) || querystate != null && !querystate.equals(network.state().toString()) || queryshared != null && !queryshared.equals(Boolean.toString(network.shared())) || querytenantId != null && !querytenantId.equals(network.tenantId().toString()) || routerExternal != null && !routerExternal.equals(Boolean.toString(network.routerExternal())) || type != null && !type.equals(network.type().toString()) || physicalNetwork != null && !physicalNetwork.equals(network.physicalNetwork().toString()) || segmentationId != null && !segmentationId.equals(network.segmentationId().toString())) continue;
            this.networksMap.putIfAbsent(network.id(), network);
        }
        networks = Collections.unmodifiableCollection(this.networksMap.values());
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("networks", (JsonNode)new TenantNetworkCodec().encode(networks, (CodecContext)this));
        return TenantNetworkWebResource.ok((Object)result.toString()).build();
    }

    private TenantNetwork.State isState(String state) {
        if (state.equals("ACTIVE")) {
            return TenantNetwork.State.ACTIVE;
        }
        if (state.equals("BUILD")) {
            return TenantNetwork.State.BUILD;
        }
        if (state.equals("DOWN")) {
            return TenantNetwork.State.DOWN;
        }
        if (state.equals("ERROR")) {
            return TenantNetwork.State.ERROR;
        }
        return null;
    }

    private TenantNetwork.Type isType(String type) {
        if (type.equals("LOCAL")) {
            return TenantNetwork.Type.LOCAL;
        }
        return null;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getNetwork(@PathParam(value="id") String id) {
        if (!((TenantNetworkService)this.get(TenantNetworkService.class)).exists(TenantNetworkId.networkId((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Network is not found").build();
        }
        TenantNetwork network = (TenantNetwork)this.nullIsNotFound((Object)((TenantNetworkService)this.get(TenantNetworkService.class)).getNetwork(TenantNetworkId.networkId((String)id)), "Network is not found");
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("network", (JsonNode)new TenantNetworkCodec().encode(network, (CodecContext)this));
        return TenantNetworkWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createNetworks(InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode cfg = mapper.readTree(input);
            JsonNode nodes = null;
            Iterable networks = null;
            if (cfg.get("network") != null) {
                nodes = cfg.get("network");
                networks = nodes.isArray() ? this.changeJson2objs(nodes) : this.changeJson2obj("create network", null, nodes);
            } else if (cfg.get("networks") != null) {
                nodes = cfg.get("networks");
                networks = this.changeJson2objs(nodes);
            }
            Boolean issuccess = (Boolean)this.nullIsNotFound((Object)((TenantNetworkService)this.get(TenantNetworkService.class)).createNetworks(networks), "Network is not found");
            if (!issuccess.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Network id is existed").build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (Exception e) {
            log.error("Creates tenantNetwork exception {}.", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateNetworks(@PathParam(value="id") String id, InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode cfg = mapper.readTree(input);
            JsonNode nodes = null;
            Iterable networks = null;
            if (cfg.get("network") != null) {
                nodes = cfg.get("network");
                networks = nodes.isArray() ? this.changeJson2objs(nodes) : this.changeJson2obj("update network", TenantNetworkId.networkId((String)id), nodes);
            } else if (cfg.get("networks") != null) {
                nodes = cfg.get("networks");
                networks = this.changeJson2objs(nodes);
            }
            Boolean issuccess = (Boolean)this.nullIsNotFound((Object)((TenantNetworkService)this.get(TenantNetworkService.class)).updateNetworks(networks), "Network is not found");
            if (!issuccess.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Network id is not existed").build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (Exception e) {
            log.error("Updates tenantNetwork failed because of exception {}.", (Object)e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteNetworks(@PathParam(value="id") String id) {
        log.debug("Deletes network by identifier {}.", (Object)id);
        HashSet<TenantNetworkId> networkSet = new HashSet<TenantNetworkId>();
        networkSet.add(TenantNetworkId.networkId((String)id));
        Boolean issuccess = (Boolean)this.nullIsNotFound((Object)((TenantNetworkService)this.get(TenantNetworkService.class)).removeNetworks(networkSet), "Network is not found");
        if (!issuccess.booleanValue()) {
            log.debug("Network identifier {} is not existed", (Object)id);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Network id is not existed").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
    }

    public Iterable<TenantNetwork> changeJson2obj(String flag, TenantNetworkId networkId, JsonNode node) {
        Preconditions.checkNotNull((Object)node, (Object)"JsonNode can not be null");
        DefaultTenantNetwork network = null;
        ConcurrentMap networksMap = Maps.newConcurrentMap();
        Preconditions.checkArgument((boolean)node.get("admin_state_up").isBoolean(), (Object)"admin_state_up should be boolean");
        Preconditions.checkArgument((boolean)node.get("shared").isBoolean(), (Object)"shared should be boolean");
        Preconditions.checkArgument((boolean)node.get("router:external").isBoolean(), (Object)"router:external should be boolean");
        String name = node.get("name").asText();
        boolean adminStateUp = node.get("admin_state_up").asBoolean();
        String state = node.get("status").asText();
        boolean shared = node.get("shared").asBoolean();
        String tenantId = node.get("tenant_id").asText();
        boolean routerExternal = node.get("router:external").asBoolean();
        String type = node.get("provider:network_type").asText();
        String physicalNetwork = node.get("provider:physical_network").asText();
        String segmentationId = node.get("provider:segmentation_id").asText();
        TenantNetworkId id = null;
        if (flag.equals("create network")) {
            id = TenantNetworkId.networkId((String)node.get("id").asText());
        } else if (flag.equals("update network")) {
            id = networkId;
        }
        network = new DefaultTenantNetwork(id, name, adminStateUp, this.isState(state), shared, TenantId.tenantId((String)tenantId), routerExternal, this.isType(type), PhysicalNetwork.physicalNetwork((String)physicalNetwork), SegmentationId.segmentationId((String)segmentationId));
        networksMap.putIfAbsent(id, network);
        return Collections.unmodifiableCollection(networksMap.values());
    }

    public Iterable<TenantNetwork> changeJson2objs(JsonNode nodes) {
        Preconditions.checkNotNull((Object)nodes, (Object)"JsonNode can not be null");
        DefaultTenantNetwork network = null;
        ConcurrentMap networksMap = Maps.newConcurrentMap();
        for (JsonNode node : nodes) {
            String id = node.get("id").asText();
            String name = node.get("name").asText();
            boolean adminStateUp = node.get("admin_state_up").asBoolean();
            String state = node.get("status").asText();
            boolean shared = node.get("shared").asBoolean();
            String tenantId = node.get("tenant_id").asText();
            boolean routerExternal = node.get("router:external").asBoolean();
            String type = node.get("provider:network_type").asText();
            String physicalNetwork = node.get("provider:physical_network").asText();
            String segmentationId = node.get("provider:segmentation_id").asText();
            network = new DefaultTenantNetwork(TenantNetworkId.networkId((String)id), name, adminStateUp, this.isState(state), shared, TenantId.tenantId((String)tenantId), routerExternal, this.isType(type), PhysicalNetwork.physicalNetwork((String)physicalNetwork), SegmentationId.segmentationId((String)segmentationId));
            networksMap.putIfAbsent(TenantNetworkId.networkId((String)id), network);
        }
        return Collections.unmodifiableCollection(networksMap.values());
    }

    protected <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }
}

