/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnweb.web.AllocationPoolsCodec;
import org.onosproject.vtnweb.web.HostRoutesCodec;

public final class SubnetCodec
extends JsonCodec<Subnet> {
    public ObjectNode encode(Subnet subnet, CodecContext context) {
        Preconditions.checkNotNull((Object)subnet, (Object)"Subnet cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("id", subnet.id().toString()).put("gateway_ip", subnet.gatewayIp().toString()).put("network_id", subnet.networkId().toString()).put("name", subnet.subnetName()).put("ip_version", subnet.ipVersion().toString()).put("cidr", subnet.cidr().toString()).put("shared", subnet.shared()).put("enabled_dchp", subnet.dhcpEnabled()).put("tenant_id", subnet.tenantId().toString()).put("ipv6_address_mode", subnet.ipV6AddressMode() == null ? null : subnet.ipV6AddressMode().toString()).put("ipv6_ra_mode", subnet.ipV6RaMode() == null ? null : subnet.ipV6RaMode().toString());
        result.set("allocation_pools", (JsonNode)new AllocationPoolsCodec().encode(subnet.allocationPools(), context));
        result.set("host_routes", (JsonNode)new HostRoutesCodec().encode(subnet.hostRoutes(), context));
        return result;
    }
}

