/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="port_pair_groups")
public class PortPairGroupWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(PortPairGroupWebResource.class);
    public static final String PORT_PAIR_GROUP_NOT_FOUND = "Port pair group not found";
    public static final String PORT_PAIR_GROUP_ID_EXIST = "Port pair group exists";
    public static final String PORT_PAIR_GROUP_ID_NOT_EXIST = "Port pair group does not exist with identifier";

    @GET
    @Produces(value={"application/json"})
    public Response getPortPairGroups() {
        Iterable portPairGroups = ((PortPairGroupService)this.get(PortPairGroupService.class)).getPortPairGroups();
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode portPairGroupEntry = result.putArray("port_pair_groups");
        if (portPairGroups != null) {
            for (PortPairGroup portPairGroup : portPairGroups) {
                portPairGroupEntry.add((JsonNode)this.codec(PortPairGroup.class).encode((Object)portPairGroup, (CodecContext)this));
            }
        }
        return PortPairGroupWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{group_id}")
    @Produces(value={"application/json"})
    public Response getPortPairGroup(@PathParam(value="group_id") String id) {
        PortPairGroup portPairGroup = (PortPairGroup)Tools.nullIsNotFound((Object)((PortPairGroupService)this.get(PortPairGroupService.class)).getPortPairGroup(PortPairGroupId.of((String)id)), (String)"Port pair group not found");
        ObjectNode result = this.mapper().createObjectNode();
        result.set("port_pair_group", (JsonNode)this.codec(PortPairGroup.class).encode((Object)portPairGroup, (CodecContext)this));
        return PortPairGroupWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPortPairGroup(InputStream stream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonTree = (ObjectNode)mapper.readTree(stream);
            JsonNode port = jsonTree.get("port_pair_group");
            PortPairGroup portPairGroup = (PortPairGroup)this.codec(PortPairGroup.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairGroupService)this.get(PortPairGroupService.class)).createPortPairGroup(portPairGroup), (String)"Port pair group not found");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Exception while creating port pair group {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @PUT
    @Path(value="{group_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePortPairGroup(@PathParam(value="group_id") String id, InputStream stream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonTree = (ObjectNode)mapper.readTree(stream);
            JsonNode port = jsonTree.get("port_pair_group");
            PortPairGroup portPairGroup = (PortPairGroup)this.codec(PortPairGroup.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean isSuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairGroupService)this.get(PortPairGroupService.class)).updatePortPairGroup(portPairGroup), (String)"Port pair group not found");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)isSuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Update port pair group failed because of exception {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Path(value="{group_id}")
    @DELETE
    public void deletePortPairGroup(@PathParam(value="group_id") String id) {
        this.log.debug("Deletes port pair group by identifier {}.", (Object)id);
        PortPairGroupId portPairGroupId = PortPairGroupId.of((String)id);
        Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairGroupService)this.get(PortPairGroupService.class)).removePortPairGroup(portPairGroupId), (String)"Port pair group not found");
        if (!issuccess.booleanValue()) {
            this.log.debug("Port pair group identifier {} does not exist", (Object)id);
        }
    }
}

