/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.DefaultFlowClassifier;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;

public final class FlowClassifierCodec
extends JsonCodec<FlowClassifier> {
    private static final String FLOW_CLASSIFIER_ID = "id";
    private static final String TENANT_ID = "tenant_id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ETHER_TYPE = "ethertype";
    private static final String PROTOCOL = "protocol";
    private static final String MIN_SRC_PORT_RANGE = "source_port_range_min";
    private static final String MAX_SRC_PORT_RANGE = "source_port_range_max";
    private static final String MIN_DST_PORT_RANGE = "destination_port_range_min";
    private static final String MAX_DST_PORT_RANGE = "destination_port_range_max";
    private static final String SRC_IP_PREFIX = "source_ip_prefix";
    private static final String DST_IP_PREFIX = "destination_ip_prefix";
    private static final String SRC_PORT = "logical_source_port";
    private static final String DST_PORT = "logical_destination_port";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Flow Classifier.";

    public FlowClassifier decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultFlowClassifier.Builder resultBuilder = new DefaultFlowClassifier.Builder();
        String flowClassifierId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(FLOW_CLASSIFIER_ID), (String)"id member is required in Flow Classifier.")).asText();
        resultBuilder.setFlowClassifierId(FlowClassifierId.of((String)flowClassifierId));
        String tenantId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TENANT_ID), (String)"tenant_id member is required in Flow Classifier.")).asText();
        resultBuilder.setTenantId(TenantId.tenantId((String)tenantId));
        String flowClassiferName = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NAME), (String)"name member is required in Flow Classifier.")).asText();
        resultBuilder.setName(flowClassiferName);
        String flowClassiferDescription = json.get(DESCRIPTION).asText();
        resultBuilder.setDescription(flowClassiferDescription);
        String etherType = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ETHER_TYPE), (String)"ethertype member is required in Flow Classifier.")).asText();
        resultBuilder.setEtherType(etherType);
        if (json.get(PROTOCOL) != null && !json.get(PROTOCOL).asText().equals("null")) {
            String protocol = json.get(PROTOCOL).asText();
            resultBuilder.setProtocol(protocol);
        }
        int minSrcPortRange = json.get(MIN_SRC_PORT_RANGE).asInt();
        resultBuilder.setMinSrcPortRange(minSrcPortRange);
        int maxSrcPortRange = json.get(MAX_SRC_PORT_RANGE).asInt();
        resultBuilder.setMaxSrcPortRange(maxSrcPortRange);
        int minDstPortRange = json.get(MIN_DST_PORT_RANGE).asInt();
        resultBuilder.setMinDstPortRange(minDstPortRange);
        int maxDstPortRange = json.get(MAX_DST_PORT_RANGE).asInt();
        resultBuilder.setMaxDstPortRange(maxDstPortRange);
        if (json.get(SRC_IP_PREFIX) != null && !json.get(SRC_IP_PREFIX).asText().equals("null")) {
            String srcIpPrefix = json.get(SRC_IP_PREFIX).asText();
            resultBuilder.setSrcIpPrefix(IpPrefix.valueOf((String)srcIpPrefix));
        }
        if (json.get(DST_IP_PREFIX) != null && !json.get(DST_IP_PREFIX).asText().equals("null")) {
            String dstIpPrefix = json.get(DST_IP_PREFIX).asText();
            resultBuilder.setDstIpPrefix(IpPrefix.valueOf((String)dstIpPrefix));
        }
        if (json.get(SRC_PORT) != null && !json.get(SRC_PORT).asText().equals("null")) {
            String srcPort = json.get(SRC_PORT).asText();
            resultBuilder.setSrcPort(VirtualPortId.portId((String)srcPort));
        }
        if (json.get(DST_PORT) != null && !json.get(DST_PORT).asText().equals("null")) {
            String dstPort = json.get(DST_PORT).asText();
            resultBuilder.setDstPort(VirtualPortId.portId((String)dstPort));
        }
        return resultBuilder.build();
    }

    public ObjectNode encode(FlowClassifier flowClassifier, CodecContext context) {
        Preconditions.checkNotNull((Object)flowClassifier, (Object)"flowClassifier cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        result.put(FLOW_CLASSIFIER_ID, flowClassifier.flowClassifierId().toString()).put(TENANT_ID, flowClassifier.tenantId().toString()).put(NAME, flowClassifier.name()).put(DESCRIPTION, flowClassifier.description()).put(ETHER_TYPE, flowClassifier.etherType()).put(PROTOCOL, flowClassifier.protocol()).put(MIN_SRC_PORT_RANGE, flowClassifier.minSrcPortRange()).put(MAX_SRC_PORT_RANGE, flowClassifier.maxSrcPortRange()).put(MIN_DST_PORT_RANGE, flowClassifier.minDstPortRange()).put(MAX_DST_PORT_RANGE, flowClassifier.maxDstPortRange());
        if (flowClassifier.srcIpPrefix() != null) {
            result.put(SRC_IP_PREFIX, flowClassifier.srcIpPrefix().toString());
        } else {
            result.put(SRC_IP_PREFIX, "null");
        }
        if (flowClassifier.dstIpPrefix() != null) {
            result.put(DST_IP_PREFIX, flowClassifier.dstIpPrefix().toString());
        } else {
            result.put(DST_IP_PREFIX, "null");
        }
        if (flowClassifier.srcPort() != null) {
            result.put(SRC_PORT, flowClassifier.srcPort().toString());
        } else {
            result.put(SRC_PORT, "null");
        }
        if (flowClassifier.dstPort() != null) {
            result.put(DST_PORT, flowClassifier.dstPort().toString());
        } else {
            result.put(DST_PORT, "null");
        }
        return result;
    }
}

