/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnweb.web.FlowClassifierCodec;
import org.onosproject.vtnweb.web.PortChainCodec;
import org.onosproject.vtnweb.web.PortPairCodec;
import org.onosproject.vtnweb.web.PortPairGroupCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VtnCodecRegistrator {
    private static Logger log = LoggerFactory.getLogger(VtnCodecRegistrator.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;

    @Activate
    public void activate() {
        this.codecService.registerCodec(PortPair.class, (JsonCodec)new PortPairCodec());
        this.codecService.registerCodec(PortPairGroup.class, (JsonCodec)new PortPairGroupCodec());
        this.codecService.registerCodec(FlowClassifier.class, (JsonCodec)new FlowClassifierCodec());
        this.codecService.registerCodec(PortChain.class, (JsonCodec)new PortChainCodec());
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        log.info("Stopped");
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }
}

