/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.onosproject.vtnweb.gui.SfcViewMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={SfcUiExtensionManager.class})
public class SfcUiExtensionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ClassLoader CL = SfcUiExtensionManager.class.getClassLoader();
    private static final String GUI = "gui";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected UiExtensionService uiExtensionService;
    private final UiExtension sfc = this.createSfcExtension();

    private UiExtension createSfcExtension() {
        ImmutableList coreViews = ImmutableList.of((Object)new UiView(UiView.Category.NETWORK, "sfc", "SFC", "nav_sfcs"));
        UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)new SfcViewMessageHandler());
        return new UiExtension.Builder(CL, (List)coreViews).messageHandlerFactory(messageHandlerFactory).resourcePath(GUI).build();
    }

    @Activate
    public void activate() {
        this.uiExtensionService.register(this.sfc);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.uiExtensionService.unregister(this.sfc);
        this.log.info("Stopped");
    }

    protected void bindUiExtensionService(UiExtensionService uiExtensionService) {
        this.uiExtensionService = uiExtensionService;
    }

    protected void unbindUiExtensionService(UiExtensionService uiExtensionService) {
        if (this.uiExtensionService == uiExtensionService) {
            this.uiExtensionService = null;
        }
    }
}

