/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.network;

import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;

@Command(scope="onos", name="tenantnetworks", description="Supports for queryingtenantNetworks by networkid")
public class TenantNetworkQueryCommand
extends AbstractShellCommand {
    @Option(name="-i", aliases={"--id"}, description="TenantNetwork id", required=false, multiValued=false)
    String id = null;
    private static final String FMT = "networkId=%s, networkName=%s, segmentationId=%s,tenantId=%s, type=%s, adminStateUp=%s";

    protected void execute() {
        TenantNetworkService service = (TenantNetworkService)TenantNetworkQueryCommand.get(TenantNetworkService.class);
        if (this.id != null) {
            TenantNetwork network = service.getNetwork(TenantNetworkId.networkId(this.id));
            this.printNetwork(network);
        } else {
            Iterable<TenantNetwork> networks = service.getNetworks();
            for (TenantNetwork network : networks) {
                this.printNetwork(network);
            }
        }
    }

    private void printNetwork(TenantNetwork network) {
        if (network == null) {
            return;
        }
        this.print(FMT, new Object[]{network.id(), network.name(), network.segmentationId(), network.tenantId(), network.type(), network.adminStateUp()});
    }
}

