/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosintegration;

import com.google.common.base.MoreObjects;
import org.onosproject.net.ConnectPoint;

public final class VoltTenant {
    private final String humanReadableName;
    private final long id;
    private final long providerService;
    private final String serviceSpecificId;
    private final String vlanId;
    private final ConnectPoint port;

    private VoltTenant(String humanReadableName, long id, long providerService, String serviceSpecificId, String vlanId, ConnectPoint port) {
        this.humanReadableName = humanReadableName;
        this.id = id;
        this.providerService = providerService;
        this.serviceSpecificId = serviceSpecificId;
        this.vlanId = vlanId;
        this.port = port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String humanReadableName() {
        return this.humanReadableName;
    }

    public long id() {
        return this.id;
    }

    public long providerService() {
        return this.providerService;
    }

    public String serviceSpecificId() {
        return this.serviceSpecificId;
    }

    public String vlanId() {
        return this.vlanId;
    }

    public ConnectPoint port() {
        return this.port;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("humanReadableName", (Object)this.humanReadableName()).add("id", this.id()).add("providerService", this.providerService()).add("serviceSpecificId", (Object)this.serviceSpecificId()).add("vlanId", (Object)this.vlanId()).add("port", (Object)this.port()).toString();
    }

    public static final class Builder {
        private String humanReadableName = "unknown";
        private long id = 0L;
        private long providerService = -1L;
        private String serviceSpecificId = "unknown";
        private String vlanId = "unknown";
        private ConnectPoint port;

        public Builder withHumanReadableName(String humanReadableName) {
            this.humanReadableName = humanReadableName;
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withServiceSpecificId(String serviceSpecificId) {
            this.serviceSpecificId = serviceSpecificId;
            return this;
        }

        public Builder withVlanId(String vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public Builder withProviderService(long providerService) {
            this.providerService = providerService;
            return this;
        }

        public Builder withPort(ConnectPoint port) {
            this.port = port;
            return this;
        }

        public VoltTenant build() {
            return new VoltTenant(this.humanReadableName, this.id, this.providerService, this.serviceSpecificId, this.vlanId, this.port);
        }
    }
}

