/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosintegration.cli;

import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.xosintegration.VoltTenant;
import org.onosproject.xosintegration.VoltTenantService;

@Command(scope="onos", name="tenants", description="Lists the inventory of VOLT tenants and their contents")
public class VoltTenantsListCommand
extends AbstractShellCommand {
    @Argument(index=0, name="tenantId", description="Tenant ID", required=false, multiValued=false)
    private String tenantId = null;

    protected void execute() {
        VoltTenantService service = (VoltTenantService)VoltTenantsListCommand.get(VoltTenantService.class);
        if (this.tenantId != null) {
            VoltTenant tenant = service.getTenant(Long.parseLong(this.tenantId));
            if (tenant != null) {
                this.print(tenant.toString(), new Object[0]);
            } else {
                this.error("Tenant not found {}", new Object[]{this.tenantId});
            }
        } else {
            Set<VoltTenant> tenants = service.getAllTenants();
            for (VoltTenant tenant : tenants) {
                this.print(tenant.toString(), new Object[0]);
            }
        }
    }
}

