/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosintegration;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.xosintegration.VoltTenant;
import org.onosproject.xosintegration.VoltTenantService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OnosXosIntegrationManager
implements VoltTenantService {
    private static final String XOS_SERVER_ADDRESS_PROPERTY_NAME = "xosServerAddress";
    private static final String XOS_SERVER_PORT_PROPERTY_NAME = "xosServerPort";
    private static final String XOS_PROVIDER_SERVICE_PROPERTY_NAME = "xosProviderService";
    private static final String TEST_XOS_SERVER_ADDRESS = "10.254.1.22";
    private static final int TEST_XOS_SERVER_PORT = 8000;
    private static final String XOS_TENANT_BASE_URI = "/xoslib/volttenant/";
    private static final int TEST_XOS_PROVIDER_SERVICE = 1;
    private static final int PRIORITY = 50000;
    private static final DeviceId FABRIC_DEVICE_ID = DeviceId.deviceId((String)"of:5e3e486e73000187");
    private static final PortNumber FABRIC_OLT_CONNECT_POINT = PortNumber.portNumber((long)2L);
    private static final PortNumber FABRIC_VCPE_CONNECT_POINT = PortNumber.portNumber((long)3L);
    private static final String FABRIC_CONTROLLER_ADDRESS = "10.0.3.136";
    private static final int FABRIC_SERVER_PORT = 8181;
    private static final String FABRIC_BASE_URI = "/onos/cordfabric/vlans/add";
    private static final DeviceId OLT_DEVICE_ID = DeviceId.deviceId((String)"of:90e2ba82f97791e9");
    private static final int OLT_UPLINK_PORT = 129;
    private static final ConnectPoint FABRIC_PORT = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:000090e2ba82f974"), PortNumber.portNumber((long)2L));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Property(name="xosServerAddress", value={"10.254.1.22"}, label="XOS Server address")
    protected String xosServerAddress = "10.254.1.22";
    @Property(name="xosServerPort", intValue={8000}, label="XOS Server port")
    protected int xosServerPort = 8000;
    @Property(name="xosProviderService", intValue={1}, label="XOS Provider Service")
    protected int xosProviderService = 1;
    private ApplicationId appId;
    private Map<String, ConnectPoint> nodeToPort;
    private Map<Long, Short> portToVlan;
    private Map<ConnectPoint, String> portToSsid;

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("XOS app is starting");
        this.cfgService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.xosintegration");
        this.setupMap();
        this.readComponentConfiguration(context);
        this.log.info("XOS({}) started", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.log.info("XOS({}) stopped", (Object)this.appId.id());
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
    }

    private void setupMap() {
        this.nodeToPort = Maps.newHashMap();
        this.nodeToPort.put("cordcompute01.onlab.us", new ConnectPoint((ElementId)FABRIC_DEVICE_ID, PortNumber.portNumber((long)4L)));
        this.nodeToPort.put("cordcompute02.onlab.us", new ConnectPoint((ElementId)FABRIC_DEVICE_ID, PortNumber.portNumber((long)3L)));
        this.portToVlan = Maps.newHashMap();
        this.portToVlan.putIfAbsent(1L, (short)201);
        this.portToVlan.putIfAbsent(6L, (short)401);
        this.portToSsid = Maps.newHashMap();
        this.portToSsid.put(new ConnectPoint((ElementId)OLT_DEVICE_ID, PortNumber.portNumber((long)1L)), "0");
        this.portToSsid.put(new ConnectPoint((ElementId)FABRIC_DEVICE_ID, PortNumber.portNumber((long)6L)), "1");
    }

    private VoltTenant jsonToTenant(JsonObject jsonTenant) {
        return VoltTenant.builder().withHumanReadableName(jsonTenant.get("humanReadableName").asString()).withId(jsonTenant.get("id").asInt()).withProviderService(jsonTenant.get("provider_service").asInt()).withServiceSpecificId(jsonTenant.get("service_specific_id").asString()).withVlanId(jsonTenant.get("vlan_id").asString()).build();
    }

    private String tenantToJson(VoltTenant tenant) {
        return "{\"humanReadableName\": \"" + tenant.humanReadableName() + "\"," + "\"id\": \"" + tenant.id() + "\"," + "\"provider_service\": \"" + tenant.providerService() + "\"," + "\"service_specific_id\": \"" + tenant.serviceSpecificId() + "\"," + "\"vlan_id\": \"" + tenant.vlanId() + "\"" + "}";
    }

    @Deprecated
    private WebResource.Builder getClientBuilder() {
        return this.getClientBuilder("");
    }

    @Deprecated
    private WebResource.Builder getClientBuilder(String uri) {
        String baseUrl = "http://" + this.xosServerAddress + ":" + Integer.toString(this.xosServerPort);
        Client client = Client.create();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter("padmin@vicci.org", "letmein"));
        WebResource resource = client.resource(baseUrl + XOS_TENANT_BASE_URI + uri);
        return (WebResource.Builder)resource.accept(new String[]{MediaType.JSON_UTF_8.toString()}).type(MediaType.JSON_UTF_8.toString());
    }

    @Deprecated
    private String getRest() {
        return this.getRest("");
    }

    @Deprecated
    private String getRest(String uri) {
        WebResource.Builder builder = this.getClientBuilder(uri);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            this.log.info("REST GET request returned error code {}", (Object)response.getStatus());
        }
        String jsonString = (String)response.getEntity(String.class);
        this.log.info("JSON read:\n{}", (Object)jsonString);
        return jsonString;
    }

    @Deprecated
    private String postRest(String json) {
        ClientResponse response;
        WebResource.Builder builder = this.getClientBuilder();
        try {
            response = (ClientResponse)builder.post(ClientResponse.class, (Object)json);
        }
        catch (ClientHandlerException e) {
            this.log.warn("Unable to contact REST server: {}", (Object)e.getMessage());
            return "{ \"error\" : \"oops no one home\" }";
        }
        if (response.getStatus() != 201) {
            this.log.info("REST POST request returned error code {}", (Object)response.getStatus());
        }
        return (String)response.getEntity(String.class);
    }

    @Deprecated
    private void deleteRest(String uri) {
        WebResource.Builder builder = this.getClientBuilder(uri);
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        if (response.getStatus() != 204) {
            this.log.info("REST DELETE request returned error code {}", (Object)response.getStatus());
        }
    }

    private void deleteTenant(long tenantId) {
        this.deleteRest(Long.toString(tenantId));
    }

    @Override
    public Set<VoltTenant> getAllTenants() {
        String jsonString = this.getRest();
        JsonArray voltTenantItems = JsonArray.readFrom((String)jsonString);
        return IntStream.range(0, voltTenantItems.size()).mapToObj(index -> this.jsonToTenant(voltTenantItems.get(index).asObject())).collect(Collectors.toSet());
    }

    @Override
    public void removeTenant(long id) {
        this.deleteTenant(id);
    }

    @Override
    public VoltTenant addTenant(VoltTenant newTenant) {
        VlanId subscriberVlan;
        long providerServiceId = newTenant.providerService();
        if (providerServiceId == -1L) {
            providerServiceId = this.xosProviderService;
        }
        PortNumber onuPort = newTenant.port().port();
        try {
            subscriberVlan = VlanId.vlanId((short)this.portToVlan.get(onuPort.toLong()));
        }
        catch (NullPointerException npe) {
            this.log.error("No matched port in portToVlan map", (Throwable)npe);
            return newTenant;
        }
        VoltTenant tenantToCreate = VoltTenant.builder().withProviderService(providerServiceId).withServiceSpecificId(this.portToSsid.get(newTenant.port())).withVlanId(String.valueOf(subscriberVlan.toShort())).withPort(newTenant.port()).build();
        String json = this.tenantToJson(tenantToCreate);
        this.provisionVlanOnPort(OLT_DEVICE_ID, 129, onuPort, subscriberVlan.toShort());
        String retJson = this.postRest(json);
        this.fetchCpeLocation(tenantToCreate, retJson);
        return newTenant;
    }

    private void fetchCpeLocation(VoltTenant newTenant, String jsonString) {
        JsonObject json = JsonObject.readFrom((String)jsonString);
        if (json.get("computeNodeName") != null) {
            ConnectPoint point = this.nodeToPort.get(json.get("computeNodeName").asString());
            ConnectPoint oltPort = new ConnectPoint((ElementId)FABRIC_DEVICE_ID, FABRIC_OLT_CONNECT_POINT);
            this.provisionFabric(VlanId.vlanId((short)Short.parseShort(newTenant.vlanId())), point, oltPort);
        }
    }

    @Override
    public VoltTenant getTenant(long id) {
        String jsonString = this.getRest(Long.toString(id));
        JsonObject jsonTenant = JsonObject.readFrom((String)jsonString);
        if (jsonTenant.get("id") != null) {
            return this.jsonToTenant(jsonTenant);
        }
        return null;
    }

    private void provisionVlanOnPort(DeviceId deviceId, int uplinkPort, PortNumber p, short vlanId) {
        TrafficSelector upstream = DefaultTrafficSelector.builder().matchVlanId(VlanId.ANY).matchInPort(p).build();
        TrafficSelector downstream = DefaultTrafficSelector.builder().matchVlanId(VlanId.vlanId((short)vlanId)).matchInPort(PortNumber.portNumber((long)uplinkPort)).build();
        TrafficTreatment upstreamTreatment = DefaultTrafficTreatment.builder().setVlanId(VlanId.vlanId((short)vlanId)).setOutput(PortNumber.portNumber((long)uplinkPort)).build();
        TrafficTreatment downstreamTreatment = DefaultTrafficTreatment.builder().popVlan().setOutput(p).build();
        ForwardingObjective upFwd = DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(1000).makePermanent().withSelector(upstream).fromApp(this.appId).withTreatment(upstreamTreatment).add();
        ForwardingObjective downFwd = DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(1000).makePermanent().withSelector(downstream).fromApp(this.appId).withTreatment(downstreamTreatment).add();
        this.flowObjectiveService.forward(deviceId, upFwd);
        this.flowObjectiveService.forward(deviceId, downFwd);
    }

    private void provisionDataPlane(VoltTenant tenant) {
        VlanId vlan = VlanId.vlanId((short)Short.parseShort(tenant.vlanId()));
        TrafficSelector fromGateway = DefaultTrafficSelector.builder().matchInPhyPort(tenant.port().port()).build();
        TrafficSelector fromFabric = DefaultTrafficSelector.builder().matchInPhyPort(FABRIC_PORT.port()).matchVlanId(vlan).build();
        TrafficTreatment toFabric = DefaultTrafficTreatment.builder().pushVlan().setVlanId(vlan).setOutput(FABRIC_PORT.port()).build();
        TrafficTreatment toGateway = DefaultTrafficTreatment.builder().popVlan().setOutput(tenant.port().port()).build();
        ForwardingObjective forwardToFabric = DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).makePermanent().fromApp(this.appId).withSelector(fromGateway).withTreatment(toFabric).add();
        ForwardingObjective forwardToGateway = DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).makePermanent().fromApp(this.appId).withSelector(fromFabric).withTreatment(toGateway).add();
        this.flowObjectiveService.forward(FABRIC_PORT.deviceId(), forwardToFabric);
        this.flowObjectiveService.forward(FABRIC_PORT.deviceId(), forwardToGateway);
    }

    private void provisionFabric(VlanId vlanId, ConnectPoint point, ConnectPoint fromPoint) {
        long vlan = vlanId.toShort();
        JsonObject node = new JsonObject();
        node.add("vlan", vlan);
        if (vlan == 201L) {
            node.add("iptv", true);
        } else {
            node.add("iptv", false);
        }
        JsonArray array = new JsonArray();
        JsonObject cp1 = new JsonObject();
        JsonObject cp2 = new JsonObject();
        cp1.add("device", point.deviceId().toString());
        cp1.add("port", point.port().toLong());
        cp2.add("device", fromPoint.deviceId().toString());
        cp2.add("port", fromPoint.port().toLong());
        array.add((JsonValue)cp1);
        array.add((JsonValue)cp2);
        node.add("ports", (JsonValue)array);
        String baseUrl = "http://10.0.3.136:" + Integer.toString(8181);
        Client client = Client.create();
        WebResource resource = client.resource(baseUrl + FABRIC_BASE_URI);
        WebResource.Builder builder = (WebResource.Builder)resource.accept(new String[]{MediaType.JSON_UTF_8.toString()}).type(MediaType.JSON_UTF_8.toString());
        try {
            builder.post(ClientResponse.class, (Object)node.toString());
        }
        catch (ClientHandlerException e) {
            this.log.warn("Unable to contact fabric REST server: {}", (Object)e.getMessage());
            return;
        }
    }

    private void readComponentConfiguration(ComponentContext context) {
        String newXosProviderServiceString;
        String newXosServerPortString;
        Dictionary properties = context.getProperties();
        String newXosServerAddress = Tools.get((Dictionary)properties, (String)XOS_SERVER_ADDRESS_PROPERTY_NAME);
        if (!Strings.isNullOrEmpty((String)newXosServerAddress)) {
            this.xosServerAddress = newXosServerAddress;
        }
        if (!Strings.isNullOrEmpty((String)(newXosServerPortString = Tools.get((Dictionary)properties, (String)XOS_SERVER_PORT_PROPERTY_NAME)))) {
            this.xosServerPort = Integer.parseInt(newXosServerPortString);
        }
        if (!Strings.isNullOrEmpty((String)(newXosProviderServiceString = Tools.get((Dictionary)properties, (String)XOS_PROVIDER_SERVICE_PROPERTY_NAME)))) {
            this.xosProviderService = Integer.parseInt(newXosProviderServiceString);
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }
}

