/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.acl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.onlab.packet.Ip4Prefix;
import org.onosproject.acl.AclRule;
import org.onosproject.acl.AclService;
import org.onosproject.acl.RuleId;
import org.onosproject.rest.AbstractWebResource;

@Path(value="rules")
public class AclWebResource
extends AbstractWebResource {
    @GET
    public Response queryAclRule() {
        List rules = ((AclService)this.get(AclService.class)).getAclRules();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (AclRule rule : rules) {
            ObjectNode node = mapper.createObjectNode();
            node.put("id", rule.id().toString());
            if (rule.srcIp() != null) {
                node.put("srcIp", rule.srcIp().toString());
            }
            if (rule.dstIp() != null) {
                node.put("dstIp", rule.dstIp().toString());
            }
            if (rule.ipProto() != 0) {
                switch (rule.ipProto()) {
                    case 1: {
                        node.put("ipProto", "ICMP");
                        break;
                    }
                    case 6: {
                        node.put("ipProto", "TCP");
                        break;
                    }
                    case 17: {
                        node.put("ipProto", "UDP");
                        break;
                    }
                }
            }
            if (rule.dstTpPort() != 0) {
                node.put("dstTpPort", rule.dstTpPort());
            }
            node.put("action", rule.action().toString());
            arrayNode.add((JsonNode)node);
        }
        root.set("aclRules", (JsonNode)arrayNode);
        return Response.ok((Object)root.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addAclRule(InputStream stream) throws URISyntaxException {
        AclRule newRule = this.jsonToRule(stream);
        return ((AclService)this.get(AclService.class)).addAclRule(newRule) ? Response.created((URI)new URI(newRule.id().toString())).build() : Response.serverError().build();
    }

    @DELETE
    @Path(value="{id}")
    public Response removeAclRule(@PathParam(value="id") String id) {
        RuleId ruleId = new RuleId(Long.parseLong(id.substring(2), 16));
        ((AclService)this.get(AclService.class)).removeAclRule(ruleId);
        return Response.noContent().build();
    }

    @DELETE
    public Response clearAcl() {
        ((AclService)this.get(AclService.class)).clearAcl();
        return Response.noContent().build();
    }

    private AclRule jsonToRule(InputStream stream) {
        int port;
        JsonNode node;
        try {
            node = this.mapper().readTree(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse ACL request", e);
        }
        AclRule.Builder rule = AclRule.builder();
        String s = node.path("srcIp").asText(null);
        if (s != null) {
            rule.srcIp(Ip4Prefix.valueOf((String)s));
        }
        if ((s = node.path("dstIp").asText(null)) != null) {
            rule.dstIp(Ip4Prefix.valueOf((String)s));
        }
        if ((s = node.path("ipProto").asText(null)) != null) {
            if ("TCP".equalsIgnoreCase(s)) {
                rule.ipProto((byte)6);
            } else if ("UDP".equalsIgnoreCase(s)) {
                rule.ipProto((byte)17);
            } else if ("ICMP".equalsIgnoreCase(s)) {
                rule.ipProto((byte)1);
            } else {
                throw new IllegalArgumentException("ipProto must be assigned to TCP, UDP, or ICMP");
            }
        }
        if ((port = node.path("dstTpPort").asInt(0)) > 0) {
            rule.dstTpPort((short)port);
        }
        if ((s = node.path("action").asText(null)) != null) {
            if ("allow".equalsIgnoreCase(s)) {
                rule.action(AclRule.Action.ALLOW);
            } else if ("deny".equalsIgnoreCase(s)) {
                rule.action(AclRule.Action.DENY);
            } else {
                throw new IllegalArgumentException("action must be ALLOW or DENY");
            }
        }
        return rule.build();
    }
}

