/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.castor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onosproject.castor.ArpService;
import org.onosproject.castor.CastorStore;
import org.onosproject.castor.ConnectivityManagerService;
import org.onosproject.castor.Peer;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="castor")
public class CastorWebResource
extends AbstractWebResource {
    @GET
    @Path(value="mac-map")
    public Response getMac() {
        String result = ((CastorStore)this.get(CastorStore.class)).getAddressMap().toString();
        ObjectNode node = this.mapper().createObjectNode().put("response", result);
        return CastorWebResource.ok((Object)node).build();
    }

    @GET
    @Path(value="get-peers")
    public Response getPeers() {
        String result = ((CastorStore)this.get(CastorStore.class)).getCustomersMap().toString();
        ObjectNode node = this.mapper().createObjectNode().put("response", result);
        return CastorWebResource.ok((Object)node).build();
    }

    @POST
    @Path(value="add-peer")
    @Consumes(value={"application/json"})
    public Response addPeer(String incomingData) {
        String arpResult = ", Mac was known";
        try {
            ObjectMapper mapper = new ObjectMapper();
            Peer peer = (Peer)mapper.readValue(incomingData, Peer.class);
            ((ConnectivityManagerService)this.get(ConnectivityManagerService.class)).setUpConnectivity(peer);
            if (((CastorStore)this.get(CastorStore.class)).getAddressMap().get(IpAddress.valueOf((String)peer.getIpAddress())) != null) {
                ((ConnectivityManagerService)this.get(ConnectivityManagerService.class)).setUpL2(peer);
            } else {
                ((ArpService)this.get(ArpService.class)).createArp(peer);
                arpResult = ", ARP packet sent, MAC was not known";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String result = "Unable to process due to some reason, Try again";
            ObjectNode node = this.mapper().createObjectNode().put("response", result);
            return CastorWebResource.ok((Object)node).build();
        }
        String result = "Success: Peer Entered" + arpResult;
        ObjectNode node = this.mapper().createObjectNode().put("response", result);
        return CastorWebResource.ok((Object)node).build();
    }

    @POST
    @Path(value="delete-peer")
    @Consumes(value={"application/json"})
    public Response deletePeer(String incomingData) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Peer peer = (Peer)mapper.readValue(incomingData, Peer.class);
            ((ConnectivityManagerService)this.get(ConnectivityManagerService.class)).deletePeer(peer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)"Unable to delete the peer").build();
        }
        String result = "Peer Deleted";
        ObjectNode node = this.mapper().createObjectNode().put("response", result);
        return CastorWebResource.ok((Object)node).build();
    }

    @POST
    @Path(value="route-server")
    @Consumes(value={"application/json"})
    public Response addRouteServer(String incomingData) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Peer peer = (Peer)mapper.readValue(incomingData, Peer.class);
            ((ConnectivityManagerService)this.get(ConnectivityManagerService.class)).start(peer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)"Unable to add the route server").build();
        }
        String result = "Server Entered";
        ObjectNode node = this.mapper().createObjectNode().put("response", result);
        return CastorWebResource.ok((Object)node).build();
    }
}

