/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.castor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onosproject.castor.CastorStore;
import org.onosproject.castor.ConnectivityManagerService;
import org.onosproject.castor.Peer;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.routing.IntentSynchronizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConnectivityManager
implements ConnectivityManagerService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CastorStore castorStore;
    private static final int PRIORITY_OFFSET = 1000;
    private static final int FLOW_PRIORITY = 500;
    private static final String SUFFIX_DST = "dst";
    private static final String SUFFIX_SRC = "src";
    private static final String SUFFIX_ICMP = "icmp";
    private static final Logger log = LoggerFactory.getLogger(ConnectivityManager.class);
    private static final short BGP_PORT = 179;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.getAppId("org.onosproject.castor");
    }

    @Deactivate
    public void deactivate() {
    }

    public void start(Peer server) {
        this.castorStore.storePeer(server);
        this.castorStore.storeServer(server);
    }

    public void stop() {
    }

    public void setUpConnectivity(Peer peer) {
        if (!this.castorStore.getCustomers().contains(peer)) {
            this.castorStore.storePeer(peer);
            this.castorStore.storeCustomer(peer);
        }
        for (Peer routeServer : this.castorStore.getServers()) {
            log.debug("Start to set up BGP paths for BGP peer and Route Server" + peer + "&" + routeServer);
            this.buildSpeakerIntents(routeServer, peer).forEach(i -> {
                this.castorStore.storePeerIntent(i.key(), i);
                this.intentSynchronizer.submit((Intent)i);
            });
        }
    }

    private Collection<PointToPointIntent> buildSpeakerIntents(Peer speaker, Peer peer) {
        ArrayList<PointToPointIntent> intents = new ArrayList<PointToPointIntent>();
        IpAddress peerAddress = IpAddress.valueOf((String)peer.getIpAddress());
        IpAddress speakerAddress = IpAddress.valueOf((String)speaker.getIpAddress());
        Preconditions.checkNotNull((Object)peerAddress);
        intents.addAll(this.buildIntents(ConnectPoint.deviceConnectPoint((String)speaker.getPort()), speakerAddress, ConnectPoint.deviceConnectPoint((String)peer.getPort()), peerAddress));
        return intents;
    }

    private Collection<PointToPointIntent> buildIntents(ConnectPoint portOne, IpAddress ipOne, ConnectPoint portTwo, IpAddress ipTwo) {
        byte icmpProtocol;
        byte tcpProtocol;
        ArrayList<PointToPointIntent> intents = new ArrayList<PointToPointIntent>();
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        if (ipOne.isIp4()) {
            tcpProtocol = 6;
            icmpProtocol = 1;
        } else {
            tcpProtocol = 6;
            icmpProtocol = 58;
        }
        TrafficSelector selector = this.buildSelector(tcpProtocol, ipOne, ipTwo, Short.valueOf((short)179), null);
        Key key = this.buildKey(ipOne, ipTwo, SUFFIX_SRC);
        intents.add(PointToPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(portOne).egressPoint(portTwo).priority(1000).build());
        selector = this.buildSelector(tcpProtocol, ipTwo, ipOne, null, Short.valueOf((short)179));
        key = this.buildKey(ipTwo, ipOne, SUFFIX_DST);
        intents.add(PointToPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(portTwo).egressPoint(portOne).priority(1000).build());
        selector = this.buildSelector(icmpProtocol, ipOne, ipTwo, null, null);
        key = this.buildKey(ipOne, ipTwo, SUFFIX_ICMP);
        intents.add(PointToPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(portOne).egressPoint(portTwo).priority(1000).build());
        selector = this.buildSelector(icmpProtocol, ipTwo, ipOne, null, null);
        key = this.buildKey(ipTwo, ipOne, SUFFIX_ICMP);
        intents.add(PointToPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(portTwo).egressPoint(portOne).priority(1000).build());
        return intents;
    }

    private TrafficSelector buildSelector(byte ipProto, IpAddress srcIp, IpAddress dstIp, Short srcTcpPort, Short dstTcpPort) {
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchIPProtocol(ipProto);
        if (dstIp.isIp4()) {
            builder.matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(IpPrefix.valueOf((IpAddress)srcIp, (int)32)).matchIPDst(IpPrefix.valueOf((IpAddress)dstIp, (int)32));
        } else {
            builder.matchEthType(Ethernet.TYPE_IPV6).matchIPv6Src(IpPrefix.valueOf((IpAddress)srcIp, (int)128)).matchIPv6Dst(IpPrefix.valueOf((IpAddress)dstIp, (int)128));
        }
        if (srcTcpPort != null) {
            builder.matchTcpSrc(TpPort.tpPort((int)srcTcpPort.shortValue()));
        }
        if (dstTcpPort != null) {
            builder.matchTcpDst(TpPort.tpPort((int)dstTcpPort.shortValue()));
        }
        return builder.build();
    }

    private Key buildKey(IpAddress srcIp, IpAddress dstIp, String suffix) {
        String keyString = srcIp.toString() + "-" + dstIp.toString() + "-" + suffix;
        return Key.of((String)keyString, (ApplicationId)this.appId);
    }

    public void setUpL2(Peer peer) {
        if (!this.castorStore.getLayer2Intents().isEmpty()) {
            this.updateExistingL2Intents(peer);
        }
        HashSet<ConnectPoint> ingressPorts = new HashSet<ConnectPoint>();
        ConnectPoint egressPort = ConnectPoint.deviceConnectPoint((String)peer.getPort());
        for (Peer inPeer : this.castorStore.getAllPeers()) {
            if (inPeer.getName().equals(peer.getName())) continue;
            ingressPorts.add(ConnectPoint.deviceConnectPoint((String)inPeer.getPort()));
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        MacAddress macAddress = (MacAddress)this.castorStore.getAddressMap().get(IpAddress.valueOf((String)peer.getIpAddress()));
        selector.matchEthDst(macAddress);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        Key key = Key.of((String)peer.getIpAddress(), (ApplicationId)this.appId);
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment).ingressPoints(ingressPorts).egressPoint(egressPort).priority(500).build();
        this.intentSynchronizer.submit((Intent)intent);
        this.castorStore.storeLayer2Intent(peer.getIpAddress(), intent);
        this.castorStore.removeCustomer(peer);
        peer.setL2(true);
        this.castorStore.storeCustomer(peer);
    }

    private void updateExistingL2Intents(Peer peer) {
        Collection oldIntents = this.castorStore.getLayer2Intents().values();
        for (MultiPointToSinglePointIntent oldIntent : oldIntents) {
            Set ingressPoints = oldIntent.ingressPoints();
            ConnectPoint egressPoint = oldIntent.egressPoint();
            if (!ingressPoints.add(ConnectPoint.deviceConnectPoint((String)peer.getPort()))) continue;
            MultiPointToSinglePointIntent updatedMp2pIntent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(oldIntent.key()).selector(oldIntent.selector()).treatment(oldIntent.treatment()).ingressPoints(ingressPoints).egressPoint(egressPoint).priority(oldIntent.priority()).build();
            this.castorStore.storeLayer2Intent(peer.getIpAddress(), updatedMp2pIntent);
            this.intentSynchronizer.submit((Intent)updatedMp2pIntent);
        }
    }

    public void deletePeer(Peer peer) {
        if (this.castorStore.getCustomers().contains(peer)) {
            this.deletel3(peer);
            for (Peer customer : this.castorStore.getCustomers()) {
                if (!customer.getIpAddress().equals(peer.getIpAddress()) || !customer.getl2Status()) continue;
                this.deleteL2(customer);
                this.updateL2AfterDeletion(customer);
            }
            this.castorStore.removeCustomer(peer);
        }
    }

    private void deletel3(Peer peer) {
        LinkedList<Key> keys = new LinkedList<Key>();
        IpAddress ipTwo = IpAddress.valueOf((String)peer.getIpAddress());
        for (Peer server : this.castorStore.getServers()) {
            IpAddress ipOne = IpAddress.valueOf((String)server.getIpAddress());
            keys.add(this.buildKey(ipOne, ipTwo, SUFFIX_SRC));
            keys.add(this.buildKey(ipTwo, ipOne, SUFFIX_DST));
            keys.add(this.buildKey(ipOne, ipTwo, SUFFIX_ICMP));
            keys.add(this.buildKey(ipTwo, ipOne, SUFFIX_ICMP));
        }
        for (Key keyDel : keys) {
            PointToPointIntent intent = (PointToPointIntent)this.castorStore.getPeerIntents().get(keyDel);
            this.intentSynchronizer.withdraw((Intent)intent);
            this.castorStore.removePeerIntent(keyDel);
        }
    }

    private void deleteL2(Peer peer) {
        this.intentSynchronizer.withdraw((Intent)this.castorStore.getLayer2Intents().get(peer.getIpAddress()));
        this.castorStore.removeLayer2Intent(peer.getIpAddress());
    }

    private void updateL2AfterDeletion(Peer peer) {
        Collection oldIntents = this.castorStore.getLayer2Intents().values();
        HashMap<String, MultiPointToSinglePointIntent> intents = new HashMap<String, MultiPointToSinglePointIntent>();
        for (MultiPointToSinglePointIntent oldIntent : oldIntents) {
            Set ingressPoints = oldIntent.ingressPoints();
            ConnectPoint egressPoint = oldIntent.egressPoint();
            if (!ingressPoints.remove(ConnectPoint.deviceConnectPoint((String)peer.getPort()))) continue;
            MultiPointToSinglePointIntent updatedMp2pIntent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(oldIntent.key()).selector(oldIntent.selector()).treatment(oldIntent.treatment()).ingressPoints(ingressPoints).egressPoint(egressPoint).priority(oldIntent.priority()).build();
            intents.put(peer.getIpAddress(), updatedMp2pIntent);
            this.intentSynchronizer.submit((Intent)updatedMp2pIntent);
        }
        for (String key : intents.keySet()) {
            this.castorStore.storeLayer2Intent(key, (MultiPointToSinglePointIntent)intents.get(key));
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCastorStore(CastorStore castorStore) {
        this.castorStore = castorStore;
    }

    protected void unbindCastorStore(CastorStore castorStore) {
        if (this.castorStore == castorStore) {
            this.castorStore = null;
        }
    }
}

