/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.MetricsDatabase;
import org.onosproject.cpman.impl.DefaultMetricsDatabase;
import org.onosproject.net.DeviceId;

public class MetricsDatabaseTest {
    private MetricsDatabase mdb;
    private static final String CPU_METRIC = "cpu";
    private static final String CPU_LOAD = "load";
    private static final String DEFAULT_RES = "resource";
    private static final String MEMORY_METRIC = "memory";
    private static final String MEMORY_FREE_PERC = "freePerc";
    private static final String MEMORY_USED_PERC = "usedPerc";
    private Map<DeviceId, MetricsDatabase> devMetricsMap;

    @Before
    public void setUp() {
        this.mdb = new DefaultMetricsDatabase.Builder().withMetricName(CPU_METRIC).withResourceName(DEFAULT_RES).addMetricType(CPU_LOAD).build();
    }

    @Test
    public void testMetricUpdate() {
        long currentTime = System.currentTimeMillis() / 1000L;
        this.mdb.updateMetric(CPU_LOAD, 30.0, currentTime);
        Assert.assertThat((Object)30.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
        this.mdb.updateMetric(CPU_LOAD, 40.0, currentTime + 60L);
        Assert.assertThat((Object)40.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
        this.mdb.updateMetric(CPU_LOAD, 50.0, currentTime + 120L);
        Assert.assertThat((Object)50.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
    }

    @Test
    @Ignore(value="FIXME: in some cases it returns incorrect range result, known as RRD4J bug")
    public void testMetricRangeFetch() {
        Assert.assertThat((Object)this.mdb.metrics(CPU_LOAD).length, (Matcher)Matchers.is((Object)1440));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.MINUTES).length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.HOURS).length, (Matcher)Matchers.is((Object)60));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.DAYS).length, (Matcher)Matchers.is((Object)1440));
        long endTime = System.currentTimeMillis() / 1000L;
        long startTime = endTime - 300L;
        Assert.assertThat((Object)this.mdb.metrics(CPU_LOAD, startTime, endTime).length, (Matcher)Matchers.is((Object)5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceededTimeRange() {
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 25, TimeUnit.HOURS).length, (Matcher)Matchers.is((Object)1440));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientTimeRange() {
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 50, TimeUnit.SECONDS).length, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMultipleMetrics() {
        MetricsDatabase multiMdb = new DefaultMetricsDatabase.Builder().withMetricName(MEMORY_METRIC).withResourceName(DEFAULT_RES).addMetricType(MEMORY_FREE_PERC).addMetricType(MEMORY_USED_PERC).build();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.putIfAbsent(MEMORY_FREE_PERC, 30.0);
        metrics.putIfAbsent(MEMORY_USED_PERC, 70.0);
        multiMdb.updateMetrics(metrics);
        Assert.assertThat((Object)30.0, (Matcher)Matchers.is((Object)multiMdb.recentMetric(MEMORY_FREE_PERC)));
        Assert.assertThat((Object)70.0, (Matcher)Matchers.is((Object)multiMdb.recentMetric(MEMORY_USED_PERC)));
    }

    @Test
    public void testDeviceMetricsMap() {
        ControlResource.Type type = ControlResource.Type.CONTROL_MESSAGE;
        DeviceId devId1 = DeviceId.deviceId((String)"of:0000000000000101");
        DeviceId devId2 = DeviceId.deviceId((String)"of:0000000000000102");
        this.devMetricsMap = Maps.newHashMap();
        ImmutableSet devices = ImmutableSet.of((Object)devId1, (Object)devId2);
        devices.forEach(dev -> {
            if (!this.devMetricsMap.containsKey(dev)) {
                this.devMetricsMap.put((DeviceId)dev, this.genMDbBuilder(type, ControlResource.CONTROL_MESSAGE_METRICS).withResourceName(dev.toString()).build());
            }
        });
        HashMap metrics1 = new HashMap();
        ControlResource.CONTROL_MESSAGE_METRICS.forEach(msgType -> metrics1.putIfAbsent(msgType.toString(), 10.0));
        HashMap metrics2 = new HashMap();
        ControlResource.CONTROL_MESSAGE_METRICS.forEach(msgType -> metrics2.putIfAbsent(msgType.toString(), 20.0));
        this.devMetricsMap.get(devId1).updateMetrics(metrics1);
        this.devMetricsMap.get(devId2).updateMetrics(metrics2);
        ControlResource.CONTROL_MESSAGE_METRICS.forEach(msgType -> Assert.assertThat((Object)10.0, (Matcher)Matchers.is((Object)this.devMetricsMap.get(devId1).recentMetric(msgType.toString()))));
        ControlResource.CONTROL_MESSAGE_METRICS.forEach(msgType -> Assert.assertThat((Object)20.0, (Matcher)Matchers.is((Object)this.devMetricsMap.get(devId2).recentMetric(msgType.toString()))));
    }

    private MetricsDatabase.Builder genMDbBuilder(ControlResource.Type resourceType, Set<ControlMetricType> metricTypes) {
        DefaultMetricsDatabase.Builder builder = new DefaultMetricsDatabase.Builder();
        builder.withMetricName(resourceType.toString());
        metricTypes.forEach(arg_0 -> MetricsDatabaseTest.lambda$genMDbBuilder$25((MetricsDatabase.Builder)builder, arg_0));
        return builder;
    }

    private static /* synthetic */ void lambda$genMDbBuilder$25(MetricsDatabase.Builder builder, ControlMetricType type) {
        builder.addMetricType(type.toString());
    }
}

