/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.glassfish.jersey.server.ResourceConfig;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsReporter;
import org.onlab.metrics.MetricsService;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.SystemInfo;
import org.onosproject.cpman.impl.SystemInfoFactory;
import org.onosproject.cpman.rest.CPManWebApplication;
import org.onosproject.rest.resources.ResourceTest;

public class ControlMetricsCollectorResourceTest
extends ResourceTest {
    final ControlPlaneMonitorService mockControlPlaneMonitorService = (ControlPlaneMonitorService)EasyMock.createMock(ControlPlaneMonitorService.class);
    final MetricsService mockMetricsService = new MockMetricsService();
    private static final String PREFIX = "collector";

    public ControlMetricsCollectorResourceTest() {
        super(ResourceConfig.forApplicationClass(CPManWebApplication.class));
    }

    @Before
    public void setUpTest() {
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ControlPlaneMonitorService.class, (Object)this.mockControlPlaneMonitorService).add(MetricsService.class, (Object)this.mockMetricsService);
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void testCpuMetricsPost() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), (Optional)EasyMock.anyObject());
        EasyMock.expectLastCall().times(5);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("cpu-metrics-post.json", "collector/cpu_metrics");
    }

    @Test
    public void testMemoryMetricsPost() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), (Optional)EasyMock.anyObject());
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("memory-metrics-post.json", "collector/memory_metrics");
    }

    @Test
    public void testDiskMetrics() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyString());
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("disk-metrics-post.json", "collector/disk_metrics");
    }

    @Test
    public void testNetworkMetrics() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyString());
        EasyMock.expectLastCall().times(8);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("network-metrics-post.json", "collector/network_metrics");
    }

    @Test
    public void testSystemInfoPost() {
        this.basePostTest("system-info-post.json", "collector/system_info");
        SystemInfo si = SystemInfoFactory.getInstance().getSystemInfo();
        Assert.assertThat((Object)si.cpuSpeed(), (Matcher)Matchers.is((Object)2048));
        Assert.assertThat((Object)si.coreCount(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)si.cpuCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)si.totalMemory(), (Matcher)Matchers.is((Object)4096));
    }

    private Response baseTest(String jsonFile, String path) {
        WebTarget wt = this.target();
        InputStream jsonStream = ControlMetricsCollectorResourceTest.class.getResourceAsStream(jsonFile);
        Assert.assertThat((Object)jsonStream, (Matcher)Matchers.notNullValue());
        return wt.path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
    }

    private void basePostTest(String jsonFile, String path) {
        Response response = this.baseTest(jsonFile, path);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    private class MockMetricsService
    implements MetricsService {
        private MockMetricsService() {
        }

        public MetricsComponent registerComponent(String name) {
            MetricsComponent metricsComponent = new MetricsComponent(name);
            return metricsComponent;
        }

        public MetricRegistry getMetricRegistry() {
            return null;
        }

        public Counter createCounter(MetricsComponent component, MetricsFeature feature, String metricName) {
            return null;
        }

        public Histogram createHistogram(MetricsComponent component, MetricsFeature feature, String metricName) {
            return null;
        }

        public Timer createTimer(MetricsComponent component, MetricsFeature feature, String metricName) {
            return null;
        }

        public Meter createMeter(MetricsComponent component, MetricsFeature feature, String metricName) {
            return new Meter();
        }

        public <T extends Metric> T registerMetric(MetricsComponent component, MetricsFeature feature, String metricName, T metric) {
            return null;
        }

        public void registerReporter(MetricsReporter reporter) {
        }

        public void unregisterReporter(MetricsReporter reporter) {
        }

        public void notifyReporters() {
        }

        public boolean removeMetric(MetricsComponent component, MetricsFeature feature, String metricName) {
            return false;
        }

        public Map<String, Timer> getTimers(MetricFilter filter) {
            return Collections.emptyMap();
        }

        public Map<String, Gauge> getGauges(MetricFilter filter) {
            return Collections.emptyMap();
        }

        public Map<String, Counter> getCounters(MetricFilter filter) {
            return Collections.emptyMap();
        }

        public Map<String, Meter> getMeters(MetricFilter filter) {
            return Collections.emptyMap();
        }

        public Map<String, Histogram> getHistograms(MetricFilter filter) {
            return Collections.emptyMap();
        }

        public Map<String, Metric> getMetrics() {
            return Collections.emptyMap();
        }

        public void removeMatching(MetricFilter filter) {
        }
    }
}

