/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.WebTarget;
import org.easymock.EasyMock;
import org.glassfish.jersey.server.ResourceConfig;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.rest.BaseResource;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.codec.impl.CodecManager;
import org.onosproject.cpman.ControlLoad;
import org.onosproject.cpman.ControlLoadSnapshot;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.codec.ControlLoadSnapshotCodec;
import org.onosproject.cpman.rest.CPManWebApplication;
import org.onosproject.rest.resources.ResourceTest;

public class ControlMetricsResourceTest
extends ResourceTest {
    final ControlPlaneMonitorService mockControlPlaneMonitorService = (ControlPlaneMonitorService)EasyMock.createMock(ControlPlaneMonitorService.class);
    final ClusterService mockClusterService = (ClusterService)EasyMock.createMock(ClusterService.class);
    Set<String> resourceSet = ImmutableSet.of((Object)"resource1", (Object)"resource2");
    NodeId nodeId;
    ControlLoad mockControlLoad;
    private static final String PREFIX = "controlmetrics";

    public ControlMetricsResourceTest() {
        super(ResourceConfig.forApplicationClass(CPManWebApplication.class));
    }

    @Before
    public void setUpTest() {
        CodecManager codecService = new CodecManager();
        codecService.activate();
        codecService.registerCodec(ControlLoadSnapshot.class, (JsonCodec)new ControlLoadSnapshotCodec());
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ControlPlaneMonitorService.class, (Object)this.mockControlPlaneMonitorService).add(ClusterService.class, (Object)this.mockClusterService).add(CodecService.class, (Object)codecService);
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
        this.nodeId = new NodeId("1");
        this.mockControlLoad = new MockControlLoad();
        MockControllerNode mockControllerNode = new MockControllerNode(this.nodeId);
        EasyMock.expect((Object)this.mockClusterService.getLocalNode()).andReturn((Object)mockControllerNode).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockClusterService});
    }

    @Test
    public void testResourceEmptyArray() {
        EasyMock.expect((Object)this.mockControlPlaneMonitorService.availableResourcesSync((NodeId)EasyMock.anyObject(), (ControlResource.Type)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of()).once();
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        WebTarget wt = this.target();
        String response = (String)wt.path("controlmetrics/disk_metrics").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"disks\":[]}"));
        EasyMock.verify((Object[])new Object[]{this.mockControlPlaneMonitorService});
    }

    @Test
    public void testResourcePopulatedArray() {
        EasyMock.expect((Object)this.mockControlPlaneMonitorService.availableResourcesSync((NodeId)EasyMock.anyObject(), (ControlResource.Type)EasyMock.anyObject())).andReturn(this.resourceSet).once();
        EasyMock.expect((Object)this.mockControlPlaneMonitorService.getLoadSync((NodeId)EasyMock.anyObject(), (ControlMetricType)EasyMock.anyObject(), EasyMock.anyString())).andReturn(null).times(4);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        WebTarget wt = this.target();
        String response = (String)wt.path("controlmetrics/disk_metrics").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"disks\":[{\"name\":\"resource1\",\"value\":{\"metrics\":[]}},{\"name\":\"resource2\",\"value\":{\"metrics\":[]}}]}"));
    }

    private static class MockControlLoad
    implements ControlLoad {
        private MockControlLoad() {
        }

        public long average(int duration, TimeUnit unit) {
            return 0L;
        }

        public long average() {
            return 10L;
        }

        public long[] recent(int duration, TimeUnit unit) {
            return new long[0];
        }

        public long[] all() {
            return new long[0];
        }

        public long rate() {
            return 0L;
        }

        public long latest() {
            return 10L;
        }

        public boolean isValid() {
            return false;
        }

        public long time() {
            return 20L;
        }
    }

    private static class MockControllerNode
    implements ControllerNode {
        final NodeId id;

        public MockControllerNode(NodeId id) {
            this.id = id;
        }

        public NodeId id() {
            return this.id;
        }

        public IpAddress ip() {
            return null;
        }

        public int tcpPort() {
            return 0;
        }
    }
}

