/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.cpman.SystemInfo;

public final class DefaultSystemInfo
implements SystemInfo {
    private final int numOfCores;
    private final int numOfCpus;
    private final int cpuSpeedMhz;
    private final int totalMemoryMbytes;

    private DefaultSystemInfo(int numOfCores, int numOfCpus, int cpuSpeedMhz, int totalMemoryMbytes) {
        this.numOfCores = numOfCores;
        this.numOfCpus = numOfCpus;
        this.cpuSpeedMhz = cpuSpeedMhz;
        this.totalMemoryMbytes = totalMemoryMbytes;
    }

    public int coreCount() {
        return this.numOfCores;
    }

    public int cpuCount() {
        return this.numOfCpus;
    }

    public int cpuSpeed() {
        return this.cpuSpeedMhz;
    }

    public int totalMemory() {
        return this.totalMemoryMbytes;
    }

    public int hashCode() {
        return Objects.hash(this.numOfCores, this.numOfCpus, this.cpuSpeedMhz, this.totalMemoryMbytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSystemInfo) {
            DefaultSystemInfo other = (DefaultSystemInfo)obj;
            return Objects.equals(this.numOfCores, other.numOfCores) && Objects.equals(this.numOfCpus, other.numOfCpus) && Objects.equals(this.cpuSpeedMhz, other.cpuSpeedMhz) && Objects.equals(this.totalMemoryMbytes, other.totalMemoryMbytes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numOfCores", this.numOfCores).add("numOfCpus", this.numOfCpus).add("cpuSpeedMhz", this.cpuSpeedMhz).add("totalMemoryMbytes", this.totalMemoryMbytes).toString();
    }
}

