/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.codahale.metrics.Meter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.impl.SystemMetricsAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SystemMetricsAggregator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_RESOURCE_NAME = "system";
    private static final String DEFAULT_METER_SUFFIX = "rate";
    private static final String DISK_RESOURCE_TYPE = "disk";
    private static final String NETWORK_RESOURCE_TYPE = "network";
    private final Map<ControlMetricType, Meter> systemMap = Maps.newHashMap();
    private final Map<String, Map<ControlMetricType, Meter>> diskMap = Maps.newHashMap();
    private final Map<String, Map<ControlMetricType, Meter>> networkMap = Maps.newHashMap();
    private MetricsService metricsService;

    public static SystemMetricsAggregator getInstance() {
        return SingletonHelper.access$000();
    }

    public void setMetricsService(MetricsService service) {
        this.metricsService = service;
    }

    public void increment(ControlMetricType type, long value) {
        ((Meter)this.systemMap.get(type)).mark(value);
    }

    public void increment(String resourceName, String resourceType, ControlMetricType type, long value) {
        if ("disk".equals(resourceType) && this.diskMap.containsKey(resourceName)) {
            ((Meter)((Map)this.diskMap.get(resourceName)).get(type)).mark(value);
        }
        if ("network".equals(resourceType) && this.networkMap.containsKey(resourceName)) {
            ((Meter)((Map)this.networkMap.get(resourceName)).get(type)).mark(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMetrics(Optional<String> optResourceName, String resType) {
        HashSet metricTypeSet = Sets.newHashSet();
        String resourceName = optResourceName.isPresent() ? optResourceName.get() : "system";
        MetricsComponent metricsComponent = this.metricsService.registerComponent(resourceName);
        if (optResourceName.isPresent()) {
            if (!this.diskMap.containsKey(resourceName) && "disk".equals(resType)) {
                metricTypeSet.addAll(ControlResource.DISK_METRICS);
                this.diskMap.putIfAbsent(resourceName, this.getMeterMap((Set)metricTypeSet, metricsComponent, this.metricsService));
                this.metricsService.notifyReporters();
                return;
            } else {
                if (this.networkMap.containsKey(resourceName) || !"network".equals(resType)) return;
                metricTypeSet.addAll(ControlResource.NETWORK_METRICS);
                this.networkMap.putIfAbsent(resourceName, this.getMeterMap((Set)metricTypeSet, metricsComponent, this.metricsService));
                this.metricsService.notifyReporters();
            }
            return;
        } else {
            if (!this.systemMap.isEmpty()) return;
            metricTypeSet.addAll(ControlResource.MEMORY_METRICS);
            metricTypeSet.addAll(ControlResource.CPU_METRICS);
            this.systemMap.putAll(this.getMeterMap((Set)metricTypeSet, metricsComponent, this.metricsService));
            this.metricsService.notifyReporters();
        }
    }

    private Map<ControlMetricType, Meter> getMeterMap(Set<ControlMetricType> types, MetricsComponent component, MetricsService service) {
        HashMap meterMap = Maps.newHashMap();
        types.forEach(type -> {
            MetricsFeature metricsFeature = component.registerFeature(type.toString());
            Meter meter = service.createMeter(component, metricsFeature, "rate");
            meterMap.putIfAbsent(type, meter);
        });
        return meterMap;
    }

    private SystemMetricsAggregator() {
    }
}

