/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Tools;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.MetricValue;
import org.onosproject.cpman.SystemInfo;
import org.onosproject.cpman.impl.DefaultSystemInfo;
import org.onosproject.cpman.impl.SystemInfoFactory;
import org.onosproject.cpman.impl.SystemMetricsAggregator;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="collector")
public class SystemMetricsCollectorWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ControlPlaneMonitorService monitorService = (ControlPlaneMonitorService)this.get(ControlPlaneMonitorService.class);
    private final MetricsService metricsService = (MetricsService)this.get(MetricsService.class);
    private static final int UPDATE_INTERVAL_IN_MINUTE = 1;
    private static final String INVALID_SYSTEM_SPECS = "Invalid system specifications";
    private static final String INVALID_RESOURCE_NAME = "Invalid resource name";
    private static final String INVALID_REQUEST = "Invalid request";
    private static final int PERCENT_CONSTANT = 100;
    private static final String SYSTEM_TYPE = "system";
    private static final String DISK_TYPE = "disk";
    private static final String NETWORK_TYPE = "network";
    private static final Set<String> MEMORY_FIELD_SET = ControlResource.MEMORY_METRICS.stream().map(type -> SystemMetricsCollectorWebResource.toCamelCase((String)type.toString(), (boolean)true)).collect(Collectors.toSet());
    private static final Set<String> CPU_FIELD_SET = ControlResource.CPU_METRICS.stream().map(type -> SystemMetricsCollectorWebResource.toCamelCase((String)type.toString(), (boolean)true)).collect(Collectors.toSet());
    private SystemMetricsAggregator aggregator = SystemMetricsAggregator.getInstance();

    @POST
    @Path(value="cpu_metrics")
    @Consumes(value={"application/json"})
    public Response cpuMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            if (jsonTree == null || !this.checkFields(jsonTree, CPU_FIELD_SET)) {
                SystemMetricsCollectorWebResource.ok((Object)root).build();
            }
            long cpuLoad = (Long)Tools.nullIsIllegal((Object)((long)(jsonTree.get("cpuLoad").asDouble() * 100.0)), (String)"Invalid request");
            long totalCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("totalCpuTime").asLong(), (String)"Invalid request");
            long sysCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("sysCpuTime").asLong(), (String)"Invalid request");
            long userCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("userCpuTime").asLong(), (String)"Invalid request");
            long cpuIdleTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("cpuIdleTime").asLong(), (String)"Invalid request");
            this.aggregator.setMetricsService(this.metricsService);
            this.aggregator.addMetrics(Optional.empty(), "system");
            ControlMetric cm = new ControlMetric(ControlMetricType.CPU_LOAD, new MetricValue.Builder().load(cpuLoad).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.CPU_LOAD, cpuLoad);
            cm = new ControlMetric(ControlMetricType.TOTAL_CPU_TIME, new MetricValue.Builder().load(totalCpuTime).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.TOTAL_CPU_TIME, totalCpuTime);
            cm = new ControlMetric(ControlMetricType.SYS_CPU_TIME, new MetricValue.Builder().load(sysCpuTime).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.SYS_CPU_TIME, sysCpuTime);
            cm = new ControlMetric(ControlMetricType.USER_CPU_TIME, new MetricValue.Builder().load(userCpuTime).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.USER_CPU_TIME, userCpuTime);
            cm = new ControlMetric(ControlMetricType.CPU_IDLE_TIME, new MetricValue.Builder().load(cpuIdleTime).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.CPU_IDLE_TIME, cpuIdleTime);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return SystemMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="memory_metrics")
    @Consumes(value={"application/json"})
    public Response memoryMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            long memFree;
            long memUsed;
            long memTotal;
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            if (jsonTree == null || !this.checkFields(jsonTree, MEMORY_FIELD_SET)) {
                SystemMetricsCollectorWebResource.ok((Object)root).build();
            }
            long memUsedRatio = (memTotal = (memUsed = ((Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryUsed").asLong(), (String)"Invalid request")).longValue()) + (memFree = ((Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryFree").asLong(), (String)"Invalid request")).longValue())) == 0L ? 0L : memUsed * 100L / memTotal;
            long memFreeRatio = memTotal == 0L ? 0L : memFree * 100L / memTotal;
            this.aggregator.setMetricsService(this.metricsService);
            this.aggregator.addMetrics(Optional.empty(), "system");
            ControlMetric cm = new ControlMetric(ControlMetricType.MEMORY_USED_RATIO, new MetricValue.Builder().load(memUsedRatio).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.MEMORY_USED_RATIO, memUsedRatio);
            cm = new ControlMetric(ControlMetricType.MEMORY_FREE_RATIO, new MetricValue.Builder().load(memFreeRatio).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.MEMORY_FREE_RATIO, memFreeRatio);
            cm = new ControlMetric(ControlMetricType.MEMORY_USED, new MetricValue.Builder().load(memUsed).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.MEMORY_USED, memUsed);
            cm = new ControlMetric(ControlMetricType.MEMORY_FREE, new MetricValue.Builder().load(memFree).add());
            this.monitorService.updateMetric(cm, 1, Optional.empty());
            this.aggregator.increment(ControlMetricType.MEMORY_FREE, memFree);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return SystemMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="disk_metrics")
    @Consumes(value={"application/json"})
    public Response diskMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            ArrayNode diskRes = jsonTree.get("disks") == null ? this.mapper().createArrayNode() : (ArrayNode)jsonTree.get("disks");
            for (JsonNode node : diskRes) {
                JsonNode resourceName = node.get("resourceName");
                Tools.nullIsIllegal((Object)resourceName, (String)"Invalid resource name");
                this.aggregator.setMetricsService(this.metricsService);
                this.aggregator.addMetrics(Optional.of(resourceName.asText()), "disk");
                long readBytes = (Long)Tools.nullIsIllegal((Object)node.get("readBytes").asLong(), (String)"Invalid request");
                long writeBytes = (Long)Tools.nullIsIllegal((Object)node.get("writeBytes").asLong(), (String)"Invalid request");
                ControlMetric cm = new ControlMetric(ControlMetricType.DISK_READ_BYTES, new MetricValue.Builder().load(readBytes).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "disk", ControlMetricType.DISK_READ_BYTES, readBytes);
                cm = new ControlMetric(ControlMetricType.DISK_WRITE_BYTES, new MetricValue.Builder().load(writeBytes).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "disk", ControlMetricType.DISK_WRITE_BYTES, writeBytes);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return SystemMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="network_metrics")
    @Consumes(value={"application/json"})
    public Response networkMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            ArrayNode networkRes = jsonTree.get("networks") == null ? this.mapper().createArrayNode() : (ArrayNode)jsonTree.get("networks");
            for (JsonNode node : networkRes) {
                JsonNode resourceName = node.get("resourceName");
                Tools.nullIsIllegal((Object)resourceName, (String)"Invalid resource name");
                this.aggregator.setMetricsService(this.metricsService);
                this.aggregator.addMetrics(Optional.of(resourceName.asText()), "network");
                long inBytes = (Long)Tools.nullIsIllegal((Object)node.get("incomingBytes").asLong(), (String)"Invalid request");
                long outBytes = (Long)Tools.nullIsIllegal((Object)node.get("outgoingBytes").asLong(), (String)"Invalid request");
                long inPackets = (Long)Tools.nullIsIllegal((Object)node.get("incomingPackets").asLong(), (String)"Invalid request");
                long outPackets = (Long)Tools.nullIsIllegal((Object)node.get("outgoingPackets").asLong(), (String)"Invalid request");
                ControlMetric cm = new ControlMetric(ControlMetricType.NW_INCOMING_BYTES, new MetricValue.Builder().load(inBytes).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "network", ControlMetricType.NW_INCOMING_BYTES, inBytes);
                cm = new ControlMetric(ControlMetricType.NW_OUTGOING_BYTES, new MetricValue.Builder().load(outBytes).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "network", ControlMetricType.NW_OUTGOING_BYTES, outBytes);
                cm = new ControlMetric(ControlMetricType.NW_INCOMING_PACKETS, new MetricValue.Builder().load(inPackets).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "network", ControlMetricType.NW_INCOMING_PACKETS, inPackets);
                cm = new ControlMetric(ControlMetricType.NW_OUTGOING_PACKETS, new MetricValue.Builder().load(outPackets).add());
                this.monitorService.updateMetric(cm, 1, resourceName.asText());
                this.aggregator.increment(resourceName.asText(), "network", ControlMetricType.NW_OUTGOING_PACKETS, outPackets);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return SystemMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="system_info")
    @Consumes(value={"application/json"})
    public Response systemInfo(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode numOfCores = jsonTree.get("numOfCores");
            JsonNode numOfCpus = jsonTree.get("numOfCpus");
            JsonNode cpuSpeed = jsonTree.get("cpuSpeed");
            JsonNode totalMemory = jsonTree.get("totalMemory");
            if (numOfCores == null || numOfCpus == null || cpuSpeed == null || totalMemory == null) {
                throw new IllegalArgumentException("Invalid system specifications");
            }
            SystemInfo systemInfo = new DefaultSystemInfo.Builder().numOfCores(numOfCores.asInt()).numOfCpus(numOfCpus.asInt()).cpuSpeed(cpuSpeed.asInt()).totalMemory(totalMemory.asInt()).build();
            SystemInfoFactory.getInstance().setSystemInfo(systemInfo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return SystemMetricsCollectorWebResource.ok((Object)root).build();
    }

    private boolean checkFields(ObjectNode node, Set<String> original) {
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (original.contains(fieldName) && node.get(fieldName) != null) continue;
            this.log.warn("Illegal field name: {}", (Object)fieldName);
            return false;
        }
        return true;
    }

    private static String toCamelCase(String value, boolean startWithLowerCase) {
        int i;
        Object[] strings = StringUtils.split((String)value.toLowerCase(), (String)"_");
        int n = i = startWithLowerCase ? 1 : 0;
        while (i < strings.length) {
            strings[i] = StringUtils.capitalize((String)strings[i]);
            ++i;
        }
        return StringUtils.join((Object[])strings);
    }
}

