/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcprelay;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.dhcprelay.DhcpRelayConfig;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DhcpRelay {
    public static final String DHCP_RELAY_APP = "org.onosproject.dhcp-relay";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    private static Ip4Address relayAgentIP = null;
    private static MacAddress relayAgentMAC = null;
    private static MacAddress myMAC = MacAddress.valueOf((String)"4f:4f:4f:4f:4f:4f");
    private final Set<ConfigFactory> factories = ImmutableSet.of((Object)new ConfigFactory<ApplicationId, DhcpRelayConfig>(SubjectFactories.APP_SUBJECT_FACTORY, DhcpRelayConfig.class, "dhcprelay"){

        public DhcpRelayConfig createConfig() {
            return new DhcpRelayConfig();
        }
    });
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    private DhcpRelayPacketProcessor dhcpRelayPacketProcessor = new DhcpRelayPacketProcessor();
    private ConnectPoint dhcpServerConnectPoint = null;
    private Ip4Address dhcpServerIp = null;
    private MacAddress dhcpServerMac = null;
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(DHCP_RELAY_APP);
        this.cfgService.addListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        this.updateConfig();
        this.packetService.addProcessor((PacketProcessor)this.dhcpRelayPacketProcessor, PacketProcessor.director((int)0));
        this.requestPackets();
        this.log.info("DHCP-RELAY Started");
        this.log.info("started the apps dhcp relay");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.packetService.removeProcessor((PacketProcessor)this.dhcpRelayPacketProcessor);
        this.cancelPackets();
        this.log.info("DHCP-RELAY Stopped");
    }

    private void updateConfig() {
        DhcpRelayConfig cfg = (DhcpRelayConfig)this.cfgService.getConfig((Object)this.appId, DhcpRelayConfig.class);
        if (cfg == null) {
            this.log.warn("Dhcp Server info not available");
            return;
        }
        this.dhcpServerConnectPoint = cfg.getDhcpServerConnectPoint();
        this.dhcpServerIp = cfg.getDhcpServerIp();
        this.dhcpServerMac = cfg.getDhcpServermac();
        this.log.info("dhcp server connect points are " + this.dhcpServerConnectPoint);
        this.log.info("dhcp server ipaddress " + this.dhcpServerIp);
        this.log.info("dhcp server mac address " + this.dhcpServerMac);
    }

    private void requestPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)67));
        this.packetService.requestPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorClient = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.requestPackets(selectorClient.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorArpServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selectorArpServer.build(), PacketPriority.CONTROL, this.appId);
    }

    private void cancelPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)67));
        this.packetService.cancelPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorClient = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.cancelPackets(selectorClient.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorArpServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selectorArpServer.build(), PacketPriority.CONTROL, this.appId);
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if ((event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(DhcpRelayConfig.class)) {
                DhcpRelay.this.updateConfig();
                DhcpRelay.this.log.info("Reconfigured");
            }
        }
    }

    private class DhcpRelayPacketProcessor
    implements PacketProcessor {
        private DhcpRelayPacketProcessor() {
        }

        public void process(PacketContext context) {
            Ethernet packet = context.inPacket().parsed();
            if (packet == null) {
                return;
            }
            if (packet.getEtherType() == Ethernet.TYPE_IPV4) {
                IPv4 ipv4Packet = (IPv4)packet.getPayload();
                if (ipv4Packet.getProtocol() == 17) {
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    DHCP dhcpPayload = (DHCP)udpPacket.getPayload();
                    if (udpPacket.getSourcePort() == 68 || udpPacket.getSourcePort() == 67) {
                        this.processDhcpPacket(context, dhcpPayload);
                    }
                }
            } else if (packet.getEtherType() == Ethernet.TYPE_ARP) {
                ARP arpPacket = (ARP)packet.getPayload();
                Set serverInterfaces = DhcpRelay.this.interfaceService.getInterfacesByPort(context.inPacket().receivedFrom());
                if (serverInterfaces.isEmpty()) {
                    DhcpRelay.this.log.warn("server virtual interface not configured");
                    return;
                }
                if (arpPacket.getOpCode() == 1 && this.checkArpRequestFrmDhcpServ(serverInterfaces, arpPacket)) {
                    this.processArpPacket(context, packet);
                }
            }
        }

        private boolean checkArpRequestFrmDhcpServ(Set<Interface> serverInterfaces, ARP arpPacket) {
            return Objects.equals(((InterfaceIpAddress)serverInterfaces.iterator().next().ipAddressesList().get(0)).ipAddress().getIp4Address(), Ip4Address.valueOf((byte[])arpPacket.getTargetProtocolAddress()));
        }

        private void forwardPacket(Ethernet packet) {
            if (DhcpRelay.this.dhcpServerConnectPoint != null) {
                TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(DhcpRelay.this.dhcpServerConnectPoint.port()).build();
                DefaultOutboundPacket o = new DefaultOutboundPacket(DhcpRelay.this.dhcpServerConnectPoint.deviceId(), t, ByteBuffer.wrap(packet.serialize()));
                DhcpRelay.this.packetService.emit((OutboundPacket)o);
            }
        }

        private void processArpPacket(PacketContext context, Ethernet packet) {
            ARP arpPacket = (ARP)packet.getPayload();
            ARP arpReply = (ARP)arpPacket.clone();
            arpReply.setOpCode((short)2);
            arpReply.setTargetProtocolAddress(arpPacket.getSenderProtocolAddress());
            arpReply.setTargetHardwareAddress(arpPacket.getSenderHardwareAddress());
            arpReply.setSenderProtocolAddress(arpPacket.getTargetProtocolAddress());
            arpReply.setSenderHardwareAddress(myMAC.toBytes());
            Ethernet ethReply = new Ethernet();
            ethReply.setSourceMACAddress(myMAC);
            ethReply.setDestinationMACAddress(packet.getSourceMAC());
            ethReply.setEtherType(Ethernet.TYPE_ARP);
            ethReply.setVlanID(packet.getVlanID());
            ethReply.setPayload((IPacket)arpReply);
            this.forwardPacket(ethReply);
        }

        private void processDhcpPacket(PacketContext context, DHCP dhcpPayload) {
            ConnectPoint inPort = context.inPacket().receivedFrom();
            Set clientServerInterfaces = DhcpRelay.this.interfaceService.getInterfacesByPort(inPort);
            if (clientServerInterfaces.isEmpty()) {
                DhcpRelay.this.log.warn("Virtual interface is not configured on {}", (Object)inPort);
                return;
            }
            if (dhcpPayload == null) {
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            DHCPPacketType incomingPacketType = null;
            for (DHCPOption option : dhcpPayload.getOptions()) {
                if (option.getCode() != DHCP.DHCPOptionCode.OptionCode_MessageType.getValue()) continue;
                byte[] data = option.getData();
                incomingPacketType = DHCPPacketType.getType((int)data[0]);
            }
            switch (incomingPacketType) {
                case DHCPDISCOVER: {
                    Ethernet ethernetPacketDiscover = this.processDhcpPacketFrmClient(context, packet, clientServerInterfaces);
                    this.forwardPacket(ethernetPacketDiscover);
                    break;
                }
                case DHCPOFFER: {
                    Ethernet ethernetPacketOffer = this.processDhcpPacketFrmServer(packet);
                    this.sendReply(ethernetPacketOffer, dhcpPayload);
                    break;
                }
                case DHCPREQUEST: {
                    Ethernet ethernetPacketRequest = this.processDhcpPacketFrmClient(context, packet, clientServerInterfaces);
                    this.forwardPacket(ethernetPacketRequest);
                    break;
                }
                case DHCPACK: {
                    Ethernet ethernetPacketAck = this.processDhcpPacketFrmServer(packet);
                    this.sendReply(ethernetPacketAck, dhcpPayload);
                    break;
                }
            }
        }

        private Ethernet processDhcpPacketFrmClient(PacketContext context, Ethernet ethernetPacket, Set<Interface> clientInterfaces) {
            relayAgentIP = ((InterfaceIpAddress)clientInterfaces.iterator().next().ipAddressesList().get(0)).ipAddress().getIp4Address();
            relayAgentMAC = clientInterfaces.iterator().next().mac();
            Ethernet etherReply = (Ethernet)ethernetPacket.clone();
            etherReply.setSourceMACAddress(relayAgentMAC);
            etherReply.setDestinationMACAddress(DhcpRelay.this.dhcpServerMac);
            IPv4 ipv4Packet = (IPv4)etherReply.getPayload();
            ipv4Packet.setSourceAddress(relayAgentIP.toInt());
            ipv4Packet.setDestinationAddress(DhcpRelay.this.dhcpServerIp.toInt());
            UDP udpPacket = (UDP)ipv4Packet.getPayload();
            DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
            dhcpPacket.setGatewayIPAddress(relayAgentIP.toInt());
            udpPacket.setPayload((IPacket)dhcpPacket);
            ipv4Packet.setPayload((IPacket)udpPacket);
            etherReply.setPayload((IPacket)ipv4Packet);
            return etherReply;
        }

        private Ethernet processDhcpPacketFrmServer(Ethernet ethernetPacket) {
            Ethernet etherReply = (Ethernet)ethernetPacket.clone();
            IPv4 ipv4Packet = (IPv4)etherReply.getPayload();
            UDP udpPacket = (UDP)ipv4Packet.getPayload();
            DHCP dhcpPayload = (DHCP)udpPacket.getPayload();
            etherReply.setDestinationMACAddress(dhcpPayload.getClientHardwareAddress());
            udpPacket.setDestinationPort(68);
            udpPacket.setPayload((IPacket)dhcpPayload);
            ipv4Packet.setPayload((IPacket)udpPacket);
            etherReply.setPayload((IPacket)ipv4Packet);
            return etherReply;
        }

        private void sendReply(Ethernet ethPacket, DHCP dhcpPayload) {
            MacAddress descMac = new MacAddress(dhcpPayload.getClientHardwareAddress());
            Host host = DhcpRelay.this.hostService.getHost(HostId.hostId((MacAddress)descMac, (VlanId)VlanId.vlanId((short)ethPacket.getVlanID())));
            if (host == null) {
                return;
            }
            ConnectPoint dhcpRequestor = new ConnectPoint(host.location().elementId(), host.location().port());
            if (dhcpRequestor != null) {
                TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(dhcpRequestor.port()).build();
                DefaultOutboundPacket o = new DefaultOutboundPacket(dhcpRequestor.deviceId(), t, ByteBuffer.wrap(ethPacket.serialize()));
                DhcpRelay.this.packetService.emit((OutboundPacket)o);
            }
        }
    }
}

