/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcprelay;

import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class DhcpRelayConfig
extends Config<ApplicationId> {
    private static final String DHCP_CONNECT_POINT = "dhcpserverConnectPoint";
    private static final String DHCP_SERVER_IP = "serverip";
    private static final String DHCP_SERVER_MAC = "servermac";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{DHCP_CONNECT_POINT, DHCP_SERVER_IP, DHCP_SERVER_MAC}) && this.isConnectPoint(DHCP_CONNECT_POINT, Config.FieldPresence.MANDATORY) && this.isIpAddress(DHCP_SERVER_IP, Config.FieldPresence.MANDATORY) && this.isMacAddress(DHCP_SERVER_MAC, Config.FieldPresence.MANDATORY);
    }

    public ConnectPoint getDhcpServerConnectPoint() {
        return ConnectPoint.deviceConnectPoint((String)this.object.path(DHCP_CONNECT_POINT).asText());
    }

    public Ip4Address getDhcpServerIp() {
        String ip = this.get(DHCP_SERVER_IP, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public MacAddress getDhcpServermac() {
        String mac = this.get(DHCP_SERVER_MAC, null);
        return mac != null ? MacAddress.valueOf((String)mac) : null;
    }
}

