/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.joda.time.LocalDateTime;
import org.onosproject.event.AbstractEvent;
import org.onosproject.evpnrouteservice.EvpnRoute;

public class EvpnRouteEvent
extends AbstractEvent<Type, EvpnRoute> {
    private final EvpnRoute prevSubject;
    private final Collection<EvpnRoute> alternativeRoutes;

    public EvpnRouteEvent(Type type, EvpnRoute subject) {
        this(type, subject, null, Collections.emptySet());
    }

    public EvpnRouteEvent(Type type, EvpnRoute subject, Collection<EvpnRoute> alternatives) {
        this(type, subject, null, alternatives);
    }

    protected EvpnRouteEvent(Type type, EvpnRoute subject, long time) {
        super((Enum)type, (Object)subject, time);
        this.prevSubject = null;
        this.alternativeRoutes = Collections.emptySet();
    }

    public EvpnRouteEvent(Type type, EvpnRoute subject, EvpnRoute prevSubject) {
        this(type, subject, prevSubject, Collections.emptySet());
    }

    public EvpnRouteEvent(Type type, EvpnRoute subject, EvpnRoute prevSubject, Collection<EvpnRoute> alternatives) {
        super((Enum)type, (Object)subject);
        this.prevSubject = prevSubject;
        this.alternativeRoutes = alternatives;
    }

    public EvpnRoute prevSubject() {
        return this.prevSubject;
    }

    public Collection<EvpnRoute> alternatives() {
        return this.alternativeRoutes;
    }

    public int hashCode() {
        return Objects.hash(this.subject(), this.type(), this.prevSubject(), this.alternativeRoutes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnRouteEvent)) {
            return false;
        }
        EvpnRouteEvent that = (EvpnRouteEvent)((Object)other);
        return Objects.equals(this.subject(), that.subject()) && Objects.equals(this.type(), that.type()) && Objects.equals(this.prevSubject, that.prevSubject) && Objects.equals(this.alternativeRoutes, that.alternativeRoutes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("time", (Object)new LocalDateTime(this.time())).add("type", (Object)this.type()).add("subject", this.subject()).add("prevSubject", (Object)this.prevSubject).add("alternatives", this.alternativeRoutes).toString();
    }

    public static enum Type {
        ROUTE_ADDED,
        ROUTE_UPDATED,
        ROUTE_REMOVED,
        ALTERNATIVE_ROUTES_CHANGED;

    }
}

