/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;

public final class EvpnInstancePrefix {
    private final MacAddress macAddress;
    private final IpPrefix ipPrefix;

    private EvpnInstancePrefix(MacAddress macAddress, IpPrefix ipPrefix) {
        Preconditions.checkNotNull((Object)macAddress);
        this.macAddress = macAddress;
        this.ipPrefix = ipPrefix;
    }

    public static EvpnInstancePrefix evpnPrefix(MacAddress macAddress, IpPrefix ipPrefix) {
        return new EvpnInstancePrefix(macAddress, ipPrefix);
    }

    public MacAddress macAddress() {
        return this.macAddress;
    }

    public IpPrefix ipPrefix() {
        return this.ipPrefix;
    }

    public int hashCode() {
        return Objects.hash(this.macAddress);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnInstancePrefix)) {
            return false;
        }
        EvpnInstancePrefix that = (EvpnInstancePrefix)other;
        return Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.ipPrefix, that.ipPrefix);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("macAddress", (Object)this.macAddress).add("ipAddress", (Object)this.ipPrefix).toString();
    }
}

