/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.evpnrouteservice.RouteDistinguisher;

public final class EvpnPrefix {
    private final RouteDistinguisher rd;
    private final MacAddress macAddress;
    private final IpPrefix ipAddress;

    public EvpnPrefix(RouteDistinguisher rd, MacAddress macAddress, IpPrefix ipAddress) {
        Preconditions.checkNotNull((Object)rd);
        Preconditions.checkNotNull((Object)macAddress);
        Preconditions.checkNotNull((Object)ipAddress);
        this.rd = rd;
        this.macAddress = macAddress;
        this.ipAddress = ipAddress;
    }

    public static EvpnPrefix evpnPrefix(RouteDistinguisher rd, MacAddress macAddress, IpPrefix ipAddress) {
        return new EvpnPrefix(rd, macAddress, ipAddress);
    }

    public RouteDistinguisher routeDistinguisher() {
        return this.rd;
    }

    public MacAddress macAddress() {
        return this.macAddress;
    }

    public IpPrefix ipAddress() {
        return this.ipAddress;
    }

    public int hashCode() {
        return Objects.hash(this.rd, this.macAddress, this.ipAddress);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnPrefix)) {
            return false;
        }
        EvpnPrefix that = (EvpnPrefix)other;
        return Objects.equals(this.macAddress(), that.macAddress()) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.rd, that.rd);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("macAddress", (Object)this.macAddress()).add("ipAddress", (Object)this.ipAddress()).add("rd", (Object)this.rd).toString();
    }
}

