/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.evpnrouteservice.EvpnNextHop;
import org.onosproject.evpnrouteservice.EvpnPrefix;
import org.onosproject.evpnrouteservice.Label;
import org.onosproject.evpnrouteservice.RouteDistinguisher;
import org.onosproject.evpnrouteservice.VpnRouteTarget;

public class EvpnRoute {
    private final Source source;
    private final MacAddress prefixMac;
    private final IpPrefix prefix;
    private final IpAddress nextHop;
    private final RouteDistinguisher rd;
    private List<VpnRouteTarget> importRtList;
    private List<VpnRouteTarget> exportRtList;
    private final Label label;

    public EvpnRoute(Source source, MacAddress prefixMac, IpPrefix prefix, IpAddress nextHop, RouteDistinguisher rd, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, Label label) {
        Preconditions.checkNotNull((Object)prefixMac);
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)rd);
        Preconditions.checkNotNull((Object)label);
        this.source = (Source)((Object)Preconditions.checkNotNull((Object)((Object)source)));
        this.prefix = prefix;
        this.prefixMac = prefixMac;
        this.nextHop = nextHop;
        this.rd = rd;
        this.importRtList = importRtList;
        this.exportRtList = exportRtList;
        this.label = label;
    }

    public EvpnRoute(Source source, MacAddress prefixMac, IpPrefix prefix, IpAddress nextHop, String rdToString, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, int labelToInt) {
        Preconditions.checkNotNull((Object)prefixMac);
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)labelToInt);
        this.source = (Source)((Object)Preconditions.checkNotNull((Object)((Object)source)));
        this.prefix = prefix;
        this.prefixMac = prefixMac;
        this.nextHop = nextHop;
        this.rd = RouteDistinguisher.routeDistinguisher(rdToString);
        this.importRtList = importRtList;
        this.exportRtList = exportRtList;
        this.label = Label.label(labelToInt);
    }

    public Source source() {
        return this.source;
    }

    public MacAddress prefixMac() {
        return this.prefixMac;
    }

    public IpPrefix prefixIp() {
        return this.prefix;
    }

    public EvpnPrefix evpnPrefix() {
        return new EvpnPrefix(this.rd, this.prefixMac, this.prefix);
    }

    public IpAddress ipNextHop() {
        return this.nextHop;
    }

    public EvpnNextHop nextHop() {
        return EvpnNextHop.evpnNextHop(this.nextHop, this.importRtList, this.exportRtList, this.label);
    }

    public RouteDistinguisher routeDistinguisher() {
        return this.rd;
    }

    public List<VpnRouteTarget> importRouteTarget() {
        return this.importRtList;
    }

    public List<VpnRouteTarget> exportRouteTarget() {
        return this.exportRtList;
    }

    public void setImportRtList(List<VpnRouteTarget> importRtList) {
        this.importRtList = importRtList;
    }

    public void setExportRtList(List<VpnRouteTarget> exportRtList) {
        this.exportRtList = exportRtList;
    }

    public Label label() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hash(this.prefixMac, this.prefix, this.nextHop, this.rd, this.importRtList, this.exportRtList, this.label);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnRoute)) {
            return false;
        }
        EvpnRoute that = (EvpnRoute)other;
        return Objects.equals(this.prefixMac, this.prefixMac) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.nextHop, that.nextHop) && Objects.equals(this.rd, that.rd) && Objects.equals(this.importRtList, that.importRtList) && Objects.equals(this.exportRtList, that.exportRtList) && Objects.equals(this.label, that.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefixMac", (Object)this.prefixMac).add("prefix", (Object)this.prefix).add("nextHop", (Object)this.nextHop).add("rd", (Object)this.rd).add("import rt", this.importRtList).add("export rt", this.exportRtList).add("label", (Object)this.label).toString();
    }

    public static enum Source {
        LOCAL,
        REMOTE;

    }
}

