/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.evpnrouteservice.EvpnPrefix;
import org.onosproject.evpnrouteservice.EvpnRoute;
import org.onosproject.evpnrouteservice.EvpnRouteTableId;

public class EvpnRouteSet {
    private final EvpnRouteTableId tableId;
    private final EvpnPrefix prefix;
    private final Set<EvpnRoute> routes;

    public EvpnRouteSet(EvpnRouteTableId tableId, EvpnPrefix prefix, Set<EvpnRoute> routes) {
        this.tableId = (EvpnRouteTableId)Preconditions.checkNotNull((Object)tableId);
        this.prefix = (EvpnPrefix)Preconditions.checkNotNull((Object)prefix);
        this.routes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(routes)));
    }

    public EvpnRouteTableId tableId() {
        return this.tableId;
    }

    public EvpnPrefix prefix() {
        return this.prefix;
    }

    public Set<EvpnRoute> routes() {
        return this.routes;
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.prefix, this.routes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnRouteSet)) {
            return false;
        }
        EvpnRouteSet that = (EvpnRouteSet)other;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.routes, that.routes);
    }
}

