/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.evpnrouteservice.EvpnInstanceName;
import org.onosproject.evpnrouteservice.RouteDistinguisher;
import org.onosproject.evpnrouteservice.VpnRouteTarget;

public final class EvpnInstance {
    private final RouteDistinguisher rd;
    private final List<VpnRouteTarget> importRtList;
    private final List<VpnRouteTarget> exportRtList;
    private final EvpnInstanceName evpnName;

    private EvpnInstance(RouteDistinguisher rd, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, EvpnInstanceName evpnName) {
        Preconditions.checkNotNull((Object)rd);
        Preconditions.checkNotNull((Object)evpnName);
        this.rd = rd;
        this.importRtList = importRtList;
        this.exportRtList = exportRtList;
        this.evpnName = evpnName;
    }

    public static EvpnInstance evpnInstance(RouteDistinguisher rd, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, EvpnInstanceName evpnName) {
        return new EvpnInstance(rd, importRtList, exportRtList, evpnName);
    }

    public RouteDistinguisher routeDistinguisher() {
        return this.rd;
    }

    public List<VpnRouteTarget> importRouteTarget() {
        return this.importRtList;
    }

    public List<VpnRouteTarget> exportRouteTarget() {
        return this.exportRtList;
    }

    public EvpnInstanceName evpnName() {
        return this.evpnName;
    }

    public int hashCode() {
        return Objects.hash(this.rd, this.importRtList, this.exportRtList, this.evpnName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnInstance)) {
            return false;
        }
        EvpnInstance that = (EvpnInstance)other;
        return Objects.equals(this.evpnName, that.evpnName) && Objects.equals(this.rd, that.rd) && Objects.equals(this.importRtList, that.importRtList) && Objects.equals(this.exportRtList, that.exportRtList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("evpnName", (Object)this.evpnName).add("rd", (Object)this.rd).add("import rt", this.importRtList).add("export rt", this.exportRtList).toString();
    }
}

