/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.evpnrouteservice.EvpnInstanceName;
import org.onosproject.evpnrouteservice.EvpnInstanceNextHop;
import org.onosproject.evpnrouteservice.EvpnInstancePrefix;
import org.onosproject.evpnrouteservice.Label;
import org.onosproject.evpnrouteservice.RouteDistinguisher;
import org.onosproject.evpnrouteservice.VpnRouteTarget;

public class EvpnInstanceRoute {
    private final EvpnInstanceName evpnName;
    private final RouteDistinguisher rd;
    private List<VpnRouteTarget> importRtList;
    private List<VpnRouteTarget> exportRtList;
    private final EvpnInstancePrefix evpnInstancePrefix;
    private final EvpnInstanceNextHop evpnInstanceNextHop;
    private final IpPrefix prefix;
    private final IpAddress nextHop;
    private final Label label;

    public EvpnInstanceRoute(EvpnInstanceName evpnName, RouteDistinguisher rd, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, EvpnInstancePrefix evpnInstancePrefix, EvpnInstanceNextHop evpnInstanceNextHop, IpPrefix prefix, IpAddress nextHop, Label label) {
        Preconditions.checkNotNull((Object)evpnName);
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)rd);
        this.evpnName = evpnName;
        this.rd = rd;
        this.importRtList = importRtList;
        this.exportRtList = exportRtList;
        this.prefix = prefix;
        this.nextHop = nextHop;
        this.evpnInstancePrefix = evpnInstancePrefix;
        this.evpnInstanceNextHop = evpnInstanceNextHop;
        this.label = label;
    }

    public EvpnInstanceName evpnInstanceName() {
        return this.evpnName;
    }

    public RouteDistinguisher routeDistinguisher() {
        return this.rd;
    }

    public List<VpnRouteTarget> importRouteTarget() {
        return this.importRtList;
    }

    public List<VpnRouteTarget> exportRouteTarget() {
        return this.exportRtList;
    }

    public void setImportRtList(List<VpnRouteTarget> importRtList) {
        this.importRtList = importRtList;
    }

    public void setExportRtList(List<VpnRouteTarget> exportRtList) {
        this.exportRtList = exportRtList;
    }

    public EvpnInstancePrefix getevpnInstancePrefix() {
        return this.evpnInstancePrefix;
    }

    public EvpnInstanceNextHop getEvpnInstanceNextHop() {
        return this.evpnInstanceNextHop;
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public Label getLabel() {
        return this.label;
    }

    public IpAddress getNextHopl() {
        return this.nextHop;
    }

    public int hashCode() {
        return Objects.hash(this.evpnName, this.prefix, this.nextHop, this.rd, this.importRtList, this.exportRtList);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnInstanceRoute)) {
            return false;
        }
        EvpnInstanceRoute that = (EvpnInstanceRoute)other;
        return Objects.equals(this.prefix, this.prefix) && Objects.equals(this.nextHop, that.nextHop) && Objects.equals(this.evpnName, that.evpnName) && Objects.equals(this.rd, that.rd) && Objects.equals(this.importRtList, that.importRtList) && Objects.equals(this.exportRtList, that.exportRtList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).add("nextHop", (Object)this.nextHop).add("rd", (Object)this.rd).add("import rt", this.importRtList).add("export rt", this.exportRtList).add("evpnName", (Object)this.evpnName).toString();
    }
}

