/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.evpnrouteservice;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.evpnrouteservice.Label;
import org.onosproject.evpnrouteservice.VpnRouteTarget;

public final class EvpnNextHop {
    private final IpAddress nextHop;
    private final List<VpnRouteTarget> importRtList;
    private final List<VpnRouteTarget> exportRtList;
    private final Label label;

    private EvpnNextHop(IpAddress nextHop, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, Label label) {
        this.nextHop = nextHop;
        this.importRtList = importRtList;
        this.exportRtList = exportRtList;
        this.label = label;
    }

    public static EvpnNextHop evpnNextHop(IpAddress nextHop, List<VpnRouteTarget> importRtList, List<VpnRouteTarget> exportRtList, Label label) {
        return new EvpnNextHop(nextHop, importRtList, exportRtList, label);
    }

    public IpAddress nextHop() {
        return this.nextHop;
    }

    public List<VpnRouteTarget> importRouteTarget() {
        return this.importRtList;
    }

    public List<VpnRouteTarget> exportRouteTarget() {
        return this.exportRtList;
    }

    public Label label() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hash(this.nextHop, this.importRtList, this.exportRtList, this.label);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EvpnNextHop)) {
            return false;
        }
        EvpnNextHop that = (EvpnNextHop)other;
        return Objects.equals(this.nextHop(), that.nextHop()) && Objects.equals(this.importRtList, that.importRtList) && Objects.equals(this.exportRtList, that.exportRtList) && Objects.equals(this.label, that.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nextHop", (Object)this.nextHop()).add("import rt list", this.importRtList).add("export rt list", this.exportRtList).add("label", (Object)this.label).toString();
    }
}

