/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.gui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.joda.time.DateTime;
import org.onosproject.faultmanagement.alarms.gui.AlarmServiceUtil;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.net.DeviceId;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.CellFormatter;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;
import org.onosproject.ui.table.cell.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmTableMessageHandler
extends UiMessageHandler {
    private static final String ALARM_TABLE_DATA_REQ = "alarmTableDataRequest";
    private static final String ALARM_TABLE_DATA_RESP = "alarmTableDataResponse";
    private static final String ALARM_TABLES = "alarmTables";
    private static final String ALARM_TABLE_DETAIL_REQ = "alarmTableDetailsRequest";
    private static final String ALARM_TABLE_DETAIL_RESP = "alarmTableDetailsResponse";
    private static final String DETAILS = "details";
    private static final String ID = "id";
    private static final String DEVICE_ID_STR = "alarmDeviceId";
    private static final String DESCRIPTION = "alarmDesc";
    private static final String SOURCE = "alarmSource";
    private static final String TIME_RAISED = "alarmTimeRaised";
    private static final String TIME_UPDATED = "alarmTimeUpdated";
    private static final String TIME_CLEARED = "alarmTimeCleared";
    private static final String SEVERITY = "alarmSeverity";
    private static final String RESULT = "result";
    private static final String[] COLUMN_IDS = new String[]{"id", "alarmDeviceId", "alarmDesc", "alarmSource", "alarmTimeRaised", "alarmSeverity"};
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new AlarmTableDataRequestHandler()), (Object)((Object)new AlarmTableDetailRequestHandler()));
    }

    private static String formatTime(Long msSinceStartOfEpoch) {
        if (msSinceStartOfEpoch == null) {
            return "-";
        }
        return new TimeFormatter().format((Object)new DateTime((Object)msSinceStartOfEpoch));
    }

    private final class AlarmTableDetailRequestHandler
    extends RequestHandler {
        private AlarmTableDetailRequestHandler() {
            super(AlarmTableMessageHandler.ALARM_TABLE_DETAIL_REQ);
        }

        public void process(long sid, ObjectNode payload) {
            AlarmTableMessageHandler.this.log.debug("sid={}, payload ={}", (Object)sid, (Object)payload);
            String id = this.string(payload, AlarmTableMessageHandler.ID, "(none)");
            Alarm alarm = AlarmServiceUtil.lookupAlarm(AlarmId.alarmId((long)Long.parseLong(id)));
            ObjectNode rootNode = AlarmTableMessageHandler.this.objectNode();
            ObjectNode data = AlarmTableMessageHandler.this.objectNode();
            rootNode.set(AlarmTableMessageHandler.DETAILS, (JsonNode)data);
            if (alarm == null) {
                rootNode.put(AlarmTableMessageHandler.RESULT, "Item with id '" + id + "' not found");
                AlarmTableMessageHandler.this.log.warn("attempted to get item detail for id '{}'", (Object)id);
            } else {
                rootNode.put(AlarmTableMessageHandler.RESULT, "Found item with id '" + id + "'");
                data.put(AlarmTableMessageHandler.ID, alarm.id().fingerprint());
                data.put(AlarmTableMessageHandler.DESCRIPTION, alarm.description());
                data.put(AlarmTableMessageHandler.DEVICE_ID_STR, alarm.deviceId().toString());
                data.put(AlarmTableMessageHandler.SOURCE, alarm.source().toString());
                long timeRaised = alarm.timeRaised();
                data.put(AlarmTableMessageHandler.TIME_RAISED, AlarmTableMessageHandler.formatTime(timeRaised));
                data.put(AlarmTableMessageHandler.TIME_UPDATED, AlarmTableMessageHandler.formatTime(alarm.timeUpdated()));
                data.put(AlarmTableMessageHandler.TIME_CLEARED, AlarmTableMessageHandler.formatTime(alarm.timeCleared()));
                data.put(AlarmTableMessageHandler.SEVERITY, alarm.severity().toString());
            }
            AlarmTableMessageHandler.this.log.debug("send ={}", (Object)rootNode);
            this.sendMessage(AlarmTableMessageHandler.ALARM_TABLE_DETAIL_RESP, 0L, rootNode);
        }
    }

    private final class AlarmTableDataRequestHandler
    extends TableRequestHandler {
        private static final String NO_ROWS_MESSAGE = "No alarms found";

        private AlarmTableDataRequestHandler() {
            super(AlarmTableMessageHandler.ALARM_TABLE_DATA_REQ, AlarmTableMessageHandler.ALARM_TABLE_DATA_RESP, AlarmTableMessageHandler.ALARM_TABLES);
        }

        protected String defaultColumnId() {
            return AlarmTableMessageHandler.ID;
        }

        protected String[] getColumnIds() {
            return COLUMN_IDS;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return NO_ROWS_MESSAGE;
        }

        protected TableModel createTableModel() {
            TableModel tm = super.createTableModel();
            tm.setFormatter(AlarmTableMessageHandler.TIME_RAISED, (CellFormatter)new TimeFormatter());
            return tm;
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            AlarmTableMessageHandler.this.log.debug(" populateTable tm={} payload ={}", (Object)tm, (Object)payload);
            String devId = this.string(payload, "devId");
            Set<Alarm> alarms = Strings.isNullOrEmpty((String)devId) ? AlarmServiceUtil.lookUpAlarms() : AlarmServiceUtil.lookUpAlarms(DeviceId.deviceId((String)devId));
            alarms.forEach(alarm -> this.populateRow(tm.addRow(), (Alarm)alarm));
        }

        private void populateRow(TableModel.Row row, Alarm alarm) {
            AlarmTableMessageHandler.this.log.debug("populate table Row row={} item ={}", (Object)row, (Object)alarm);
            row.cell(AlarmTableMessageHandler.ID, (Object)alarm.id().fingerprint()).cell(AlarmTableMessageHandler.DEVICE_ID_STR, (Object)alarm.deviceId()).cell(AlarmTableMessageHandler.DESCRIPTION, (Object)alarm.description()).cell(AlarmTableMessageHandler.SOURCE, (Object)alarm.source()).cell(AlarmTableMessageHandler.TIME_RAISED, (Object)new DateTime(alarm.timeRaised())).cell(AlarmTableMessageHandler.SEVERITY, (Object)alarm.severity());
        }
    }
}

