/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.gui;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.HostId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmTopovMessageHandler
extends UiMessageHandler {
    private static final String ALARM_TOPOV_DISPLAY_START = "alarmTopovDisplayStart";
    private static final String ALARM_TOPOV_DISPLAY_UPDATE = "alarmTopovDisplayUpdate";
    private static final String ALARM_TOPOV_DISPLAY_STOP = "alarmTopovDisplayStop";
    private static final String ID = "id";
    private static final String MODE = "mode";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DeviceService deviceService;
    private HostService hostService;
    private AlarmService alarmService;
    private Mode currentMode = Mode.IDLE;
    private Element elementOfNote;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.alarmService = (AlarmService)directory.get(AlarmService.class);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new DisplayStartHandler()), (Object)((Object)new DisplayUpdateHandler()), (Object)((Object)new DisplayStopHandler()));
    }

    private void clearState() {
        this.currentMode = Mode.IDLE;
        this.elementOfNote = null;
    }

    private void updateForMode(String id) {
        this.log.debug("host service: {}", (Object)this.hostService);
        this.log.debug("device service: {}", (Object)this.deviceService);
        try {
            HostId hid = HostId.hostId((String)id);
            this.log.debug("host id {}", (Object)hid);
            this.elementOfNote = this.hostService.getHost(hid);
            this.log.debug("host element {}", (Object)this.elementOfNote);
        }
        catch (RuntimeException e) {
            try {
                DeviceId did = DeviceId.deviceId((String)id);
                this.log.debug("device id {}", (Object)did);
                this.elementOfNote = this.deviceService.getDevice(did);
                this.log.debug("device element {}", (Object)this.elementOfNote);
            }
            catch (RuntimeException e2) {
                this.log.debug("Unable to process ID [{}]", (Object)id);
                this.elementOfNote = null;
            }
        }
        switch (this.currentMode) {
            case MOUSE: {
                this.sendMouseData();
                break;
            }
        }
    }

    private void clearForMode() {
        this.sendHighlights(new Highlights());
    }

    private void sendHighlights(Highlights highlights) {
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private void sendMouseData() {
        if (this.elementOfNote != null && this.elementOfNote instanceof Device) {
            DeviceId devId = (DeviceId)this.elementOfNote.id();
            Set alarmsOnDevice = this.alarmService.getAlarms(devId);
            Highlights highlights = new Highlights();
            this.addDeviceBadge(highlights, devId, alarmsOnDevice.size());
            this.sendHighlights(highlights);
        }
    }

    private void addDeviceBadge(Highlights h, DeviceId devId, int n) {
        DeviceHighlight dh = new DeviceHighlight(devId.toString());
        dh.setBadge(this.createBadge(n));
        h.add(dh);
    }

    private NodeBadge createBadge(int n) {
        NodeBadge.Status status = n > 0 ? NodeBadge.Status.ERROR : NodeBadge.Status.INFO;
        String noun = n > 0 ? "(Alarmed)" : "(Normal)";
        String msg = "Alarms: " + n + " " + noun;
        return NodeBadge.number((NodeBadge.Status)status, (int)n, (String)msg);
    }

    private final class DisplayStopHandler
    extends RequestHandler {
        public DisplayStopHandler() {
            super(AlarmTopovMessageHandler.ALARM_TOPOV_DISPLAY_STOP);
        }

        public void process(long sid, ObjectNode payload) {
            AlarmTopovMessageHandler.this.log.debug("Stop Display");
            AlarmTopovMessageHandler.this.clearState();
            AlarmTopovMessageHandler.this.clearForMode();
        }
    }

    private final class DisplayUpdateHandler
    extends RequestHandler {
        public DisplayUpdateHandler() {
            super(AlarmTopovMessageHandler.ALARM_TOPOV_DISPLAY_UPDATE);
        }

        public void process(long sid, ObjectNode payload) {
            String id = this.string(payload, AlarmTopovMessageHandler.ID);
            AlarmTopovMessageHandler.this.log.debug("Update Display: id [{}]", (Object)id);
            if (!Strings.isNullOrEmpty((String)id)) {
                AlarmTopovMessageHandler.this.updateForMode(id);
            } else {
                AlarmTopovMessageHandler.this.clearForMode();
            }
        }
    }

    private final class DisplayStartHandler
    extends RequestHandler {
        public DisplayStartHandler() {
            super(AlarmTopovMessageHandler.ALARM_TOPOV_DISPLAY_START);
        }

        public void process(long sid, ObjectNode payload) {
            String mode = this.string(payload, AlarmTopovMessageHandler.MODE);
            AlarmTopovMessageHandler.this.log.debug("Start Display: mode [{}]", (Object)mode);
            AlarmTopovMessageHandler.this.clearState();
            AlarmTopovMessageHandler.this.clearForMode();
            switch (mode) {
                case "mouse": {
                    AlarmTopovMessageHandler.this.currentMode = Mode.MOUSE;
                    AlarmTopovMessageHandler.this.sendMouseData();
                    break;
                }
                default: {
                    AlarmTopovMessageHandler.this.currentMode = Mode.IDLE;
                }
            }
        }
    }

    private static enum Mode {
        IDLE,
        MOUSE;

    }
}

