/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.gui;

import java.util.Map;
import org.onosproject.faultmanagement.alarms.gui.AlarmServiceUtil;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.net.DeviceId;
import org.onosproject.ui.UiTopoOverlay;
import org.onosproject.ui.topo.ButtonId;
import org.onosproject.ui.topo.PropertyPanel;
import org.onosproject.ui.topo.TopoConstants;

public class AlarmTopovOverlay
extends UiTopoOverlay {
    private static final String OVERLAY_ID = "alarmsTopo-overlay";
    private static final ButtonId ALARM1_BUTTON = new ButtonId("alarm1button");
    private static final ButtonId ALARM2_BUTTON = new ButtonId("alarm2button");

    public AlarmTopovOverlay() {
        super(OVERLAY_ID);
    }

    public void modifySummary(PropertyPanel pp) {
        pp.title("Alarms Overview");
        pp.removeAllProps();
        Map<Alarm.SeverityLevel, Long> countsForAll = AlarmServiceUtil.lookUpAlarmCounts();
        this.addAlarmCountsProperties(pp, countsForAll);
    }

    public void modifyDeviceDetails(PropertyPanel pp, DeviceId deviceId) {
        pp.title("Alarm Details");
        pp.removeProps(new String[]{"Latitude", "Longitude", "Ports", "Flows", "Tunnels", "Serial Number", "Protocol"});
        Map<Alarm.SeverityLevel, Long> countsForDevice = AlarmServiceUtil.lookUpAlarmCounts(deviceId);
        this.addAlarmCountsProperties(pp, countsForDevice);
        pp.addButton(ALARM1_BUTTON).addButton(ALARM2_BUTTON);
        pp.removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_PORT_VIEW}).removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_GROUP_VIEW}).removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_METER_VIEW});
    }

    private void addAlarmCountsProperties(PropertyPanel pp, Map<Alarm.SeverityLevel, Long> countsForDevice) {
        long cr = countsForDevice.getOrDefault(Alarm.SeverityLevel.CRITICAL, 0L);
        long ma = countsForDevice.getOrDefault(Alarm.SeverityLevel.MAJOR, 0L);
        long mi = countsForDevice.getOrDefault(Alarm.SeverityLevel.MINOR, 0L);
        long wa = countsForDevice.getOrDefault(Alarm.SeverityLevel.WARNING, 0L);
        long in = countsForDevice.getOrDefault(Alarm.SeverityLevel.INDETERMINATE, 0L);
        long cl = countsForDevice.getOrDefault(Alarm.SeverityLevel.CLEARED, 0L);
        pp.addProp("Critical", cr);
        pp.addProp("Major", ma);
        pp.addProp("Minor", mi);
        pp.addProp("Warning", wa);
        pp.addProp("Indeter.", in);
        pp.addProp("Cleared", cl);
        pp.addSeparator();
        pp.addProp("Total", cr + ma + mi + wa + in + cl);
    }
}

