/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Dictionary;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderRegistry;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderService;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PollingAlarmProvider
extends AbstractProvider
implements AlarmProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected AlarmProviderRegistry providerRegistry;
    protected AlarmProviderService providerService;
    protected ScheduledExecutorService alarmsExecutor;
    private ScheduledFuture<?> scheduledTask;
    private ExecutorService eventHandlingExecutor;
    protected final MastershipListener mastershipListener = new InternalMastershipListener();
    protected final DeviceListener deviceListener = new InternalDeviceListener();
    private static final int CORE_POOL_SIZE = 10;
    private static final int DEFAULT_POLL_FREQUENCY_SECONDS = 60;
    @Property(name="alarmPollFrequencySeconds", intValue={60}, label="Frequency (in seconds) for polling alarm from devices")
    protected int alarmPollFrequencySeconds = 60;
    private static final int DEFAULT_CLEAR_FREQUENCY_SECONDS = 500;
    @Property(name="clearedAlarmPurgeSeconds", intValue={500}, label="Frequency (in seconds) for deleting cleared alarms")
    private int clearedAlarmPurgeFrequencySeconds = 500;

    public PollingAlarmProvider() {
        super(new ProviderId("default", "org.onosproject.core"));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.alarmsExecutor = Executors.newScheduledThreadPool(10, Tools.groupedThreads((String)"onos/pollingalarmprovider", (String)"alarm-executor-%d", (Logger)this.log));
        this.eventHandlingExecutor = Executors.newFixedThreadPool(10, Tools.groupedThreads((String)"onos/pollingalarmprovider", (String)"device-installer-%d", (Logger)this.log));
        this.providerService = (AlarmProviderService)this.providerRegistry.register((Provider)this);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        if (context == null) {
            this.alarmPollFrequencySeconds = 60;
            this.log.info("No component configuration");
        } else {
            Dictionary properties = context.getProperties();
            this.alarmPollFrequencySeconds = this.getNewPollFrequency(properties, this.alarmPollFrequencySeconds);
        }
        this.scheduledTask = this.schedulePolling();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.alarmsExecutor.shutdown();
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        if (context == null) {
            this.log.info("No component configuration");
            return;
        }
        Dictionary properties = context.getProperties();
        int newPollFrequency = this.getNewPollFrequency(properties, this.alarmPollFrequencySeconds);
        if (newPollFrequency != this.alarmPollFrequencySeconds) {
            this.alarmPollFrequencySeconds = newPollFrequency;
            this.scheduledTask.cancel(true);
            this.scheduledTask = this.schedulePolling();
        }
    }

    private ScheduledFuture schedulePolling() {
        return this.alarmsExecutor.scheduleAtFixedRate(this::consumeAlarms, this.alarmPollFrequencySeconds / 4, this.alarmPollFrequencySeconds, TimeUnit.SECONDS);
    }

    private int getNewPollFrequency(Dictionary<?, ?> properties, int pollFrequency) {
        int newPollFrequency;
        try {
            String s = Tools.get(properties, (String)"pollFrequency");
            newPollFrequency = Strings.isNullOrEmpty((String)s) ? pollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPollFrequency = 60;
        }
        return newPollFrequency;
    }

    public void triggerProbe(DeviceId deviceId) {
        if (this.mastershipService.isLocalMaster(deviceId)) {
            this.triggerProbe(this.deviceService.getDevice(deviceId));
        }
    }

    private void triggerProbe(Device device) {
        this.alarmsExecutor.submit(() -> this.consumeAlarms(device));
    }

    private void consumeAlarms() {
        this.deviceService.getAvailableDevices().forEach(device -> {
            if (this.mastershipService.isLocalMaster(device.id())) {
                this.consumeAlarms((Device)device);
            }
        });
    }

    private void consumeAlarms(Device device) {
        if (device.is(AlarmConsumer.class)) {
            this.providerService.updateAlarmList(device.id(), (Collection)((AlarmConsumer)device.as(AlarmConsumer.class)).consumeAlarms());
        } else {
            this.log.debug("Device {} does not support alarm consumer behaviour", (Object)device.id());
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindProviderRegistry(AlarmProviderRegistry alarmProviderRegistry) {
        this.providerRegistry = alarmProviderRegistry;
    }

    protected void unbindProviderRegistry(AlarmProviderRegistry alarmProviderRegistry) {
        if (this.providerRegistry == alarmProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public boolean isRelevant(DeviceEvent event) {
            return ((DeviceEvent.Type)event.type()).equals((Object)DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED) && PollingAlarmProvider.this.deviceService.isAvailable(((Device)event.subject()).id());
        }

        public void event(DeviceEvent event) {
            PollingAlarmProvider.this.log.debug("InternalDeviceListener has got event from device-service{} with ", (Object)event);
            PollingAlarmProvider.this.eventHandlingExecutor.execute(() -> PollingAlarmProvider.this.triggerProbe(((Device)event.subject()).id()));
        }
    }

    private class InternalMastershipListener
    implements MastershipListener {
        private InternalMastershipListener() {
        }

        public boolean isRelevant(MastershipEvent event) {
            return PollingAlarmProvider.this.mastershipService.isLocalMaster((DeviceId)event.subject());
        }

        public void event(MastershipEvent event) {
            PollingAlarmProvider.this.triggerProbe((DeviceId)event.subject());
        }
    }
}

