/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.event.EventSink;
import org.onosproject.faultmanagement.api.AlarmStore;
import org.onosproject.faultmanagement.api.AlarmStoreDelegate;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmListener;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderRegistry;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderService;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class AlarmManager
extends AbstractListenerProviderRegistry<AlarmEvent, AlarmListener, AlarmProvider, AlarmProviderService>
implements AlarmService,
AlarmProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected AlarmStore store;
    protected AlarmStoreDelegate delegate = arg_0 -> ((AlarmManager)this).post(arg_0);
    private final AtomicLong alarmIdGenerator = new AtomicLong(0L);
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    @Activate
    public void activate() {
        this.store.setDelegate(this.delegate);
        this.eventDispatcher.addSink(AlarmEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate(this.delegate);
        this.eventDispatcher.removeSink(AlarmEvent.class);
        this.log.info("Stopped");
    }

    @Modified
    public boolean modified() {
        this.log.info("Modified");
        return true;
    }

    public Alarm updateBookkeepingFields(AlarmId id, boolean isAcknowledged, String assignedUser) {
        Alarm found = this.store.getAlarm(id);
        if (found == null) {
            throw new ItemNotFoundException("Alarm with id " + id + " found");
        }
        DefaultAlarm updated = new DefaultAlarm.Builder(found).withId(found.id()).withAcknowledged(isAcknowledged).withAssignedUser(assignedUser).build();
        this.store.setAlarm((Alarm)updated);
        return updated;
    }

    public Alarm clear(AlarmId id) {
        Alarm found = this.store.getAlarm(id);
        if (found == null) {
            this.log.warn("Alarm {} is not present", (Object)id);
            return null;
        }
        DefaultAlarm updated = new DefaultAlarm.Builder(found).withId(id).clear().build();
        this.store.setAlarm((Alarm)updated);
        return updated;
    }

    public Map<Alarm.SeverityLevel, Long> getAlarmCounts(DeviceId deviceId) {
        return this.getAlarms(deviceId).stream().collect(Collectors.groupingBy(Alarm::severity, Collectors.counting()));
    }

    public Map<Alarm.SeverityLevel, Long> getAlarmCounts() {
        return this.getAlarms().stream().collect(Collectors.groupingBy(Alarm::severity, Collectors.counting()));
    }

    public Alarm getAlarm(AlarmId alarmId) {
        return (Alarm)Tools.nullIsNotFound((Object)this.store.getAlarm((AlarmId)Preconditions.checkNotNull((Object)alarmId, (Object)"Alarm Id cannot be null")), (String)"Alarm is not found");
    }

    public Set<Alarm> getAlarms() {
        return ImmutableSet.copyOf(this.store.getAlarms());
    }

    public Set<Alarm> getActiveAlarms() {
        return ImmutableSet.copyOf((Collection)this.store.getAlarms().stream().filter(a -> !a.severity().equals((Object)Alarm.SeverityLevel.CLEARED)).collect(Collectors.toSet()));
    }

    public Set<Alarm> getAlarms(Alarm.SeverityLevel severity) {
        return ImmutableSet.copyOf((Collection)this.store.getAlarms().stream().filter(a -> a.severity().equals((Object)severity)).collect(Collectors.toSet()));
    }

    public Set<Alarm> getAlarms(DeviceId deviceId) {
        return ImmutableSet.copyOf(this.store.getAlarms(deviceId));
    }

    private Set<Alarm> getActiveAlarms(DeviceId deviceId) {
        return ImmutableSet.copyOf((Collection)this.getActiveAlarms().stream().filter(a -> deviceId.equals((Object)a.deviceId())).collect(Collectors.toSet()));
    }

    public Set<Alarm> getAlarms(DeviceId deviceId, AlarmEntityId source) {
        return ImmutableSet.copyOf((Collection)this.getAlarms(deviceId).stream().filter(a -> source.equals((Object)a.source())).collect(Collectors.toSet()));
    }

    public Set<Alarm> getAlarmsForLink(ConnectPoint src, ConnectPoint dst) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarmsForFlow(DeviceId deviceId, long flowId) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    protected AlarmProviderService createProviderService(AlarmProvider provider) {
        return new InternalAlarmProviderService(provider);
    }

    protected synchronized void updateAlarms(DeviceId deviceId, Set<Alarm> discoveredSet) {
        Set<Alarm> storedSet = this.getActiveAlarms(deviceId);
        this.log.debug("CurrentNeAlarms={}. DiscoveredAlarms={}", storedSet, discoveredSet);
        if (CollectionUtils.isEqualCollection(storedSet, discoveredSet)) {
            this.log.debug("No update for {}.", (Object)deviceId);
            return;
        }
        storedSet.stream().filter(stored -> !discoveredSet.contains(stored)).forEach(stored -> {
            this.log.debug("Alarm will be Cleared as it is not on the device. Cleared alarm: {}.", stored);
            this.clear(stored.id());
        });
        discoveredSet.stream().filter(discovered -> !storedSet.contains(discovered)).forEach(discovered -> {
            this.log.info("New alarm raised {}", discovered);
            AlarmId id = this.generateAlarmId();
            this.store.setAlarm((Alarm)new DefaultAlarm.Builder(discovered).withId(id).build());
        });
    }

    private AlarmId generateAlarmId() {
        return AlarmId.alarmId((long)this.alarmIdGenerator.incrementAndGet());
    }

    protected void bindStore(AlarmStore alarmStore) {
        this.store = alarmStore;
    }

    protected void unbindStore(AlarmStore alarmStore) {
        if (this.store == alarmStore) {
            this.store = null;
        }
    }

    private class InternalAlarmProviderService
    extends AbstractProviderService<AlarmProvider>
    implements AlarmProviderService {
        InternalAlarmProviderService(AlarmProvider provider) {
            super((Provider)provider);
        }

        public void updateAlarmList(DeviceId deviceId, Collection<Alarm> alarms) {
            AlarmManager.this.updateAlarms(deviceId, (Set<Alarm>)ImmutableSet.copyOf(alarms));
        }
    }
}

