/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.faultmanagement.web.AlarmCodec;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class AlarmCodecRegistrator {
    private static final Logger log = LoggerFactory.getLogger(AlarmCodecRegistrator.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;

    @Activate
    public void activate() {
        this.codecService.registerCodec(Alarm.class, (JsonCodec)new AlarmCodec());
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        log.info("Stopped");
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }
}

