/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowanalyzer;

import java.util.Arrays;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.flowanalyzer.FlowAnalyzer;
import org.onosproject.flowanalyzer.MockFlowRuleService;
import org.onosproject.flowanalyzer.MockLinkService;
import org.onosproject.flowanalyzer.MockTopologyService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.topology.TopologyService;

public class FlowAnalyzerTest {
    FlowRuleService flowRuleService = new MockFlowRuleService();
    TopologyService topologyService;
    MockLinkService linkService = new MockLinkService();

    @Test
    @Ignore(value="This needs to be reworked to be more robust")
    public void basic() {
        this.flowRuleService = new MockFlowRuleService();
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-001", 110L, 90L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-001", 110L, 100L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-001", 110L, 150L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-002", 80L, 70L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-003", 120L, 130L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-004", 50L)});
        this.flowRuleService.applyFlowRules(new FlowRule[]{this.genFlow("ATL-005", 140L, 10L)});
        this.linkService.addLink("H00:00:00:00:00:0660", 160L, "ATL-005", 140L);
        this.linkService.addLink("ATL-005", 10L, "ATL-004", 40L);
        this.linkService.addLink("ATL-004", 50L, "ATL-002", 80L);
        this.linkService.addLink("ATL-002", 70L, "ATL-001", 110L);
        this.linkService.addLink("ATL-001", 150L, "H00:00:00:00:00:0770", 170L);
        this.linkService.addLink("ATL-001", 90L, "ATL-004", 30L);
        this.linkService.addLink("ATL-001", 100L, "ATL-003", 120L);
        this.linkService.addLink("ATL-003", 130L, "ATL-005", 20L);
        this.topologyService = new MockTopologyService(this.linkService.createdGraph);
        FlowAnalyzer flowAnalyzer = new FlowAnalyzer();
        flowAnalyzer.flowRuleService = this.flowRuleService;
        flowAnalyzer.linkService = this.linkService;
        flowAnalyzer.topologyService = this.topologyService;
        String labels = flowAnalyzer.analysisOutput();
        String correctOutput = "Flow Rule: Device: atl-005, [IN_PORT{port=140}], [OUTPUT{port=10}]\nAnalysis: Cleared!\n\nFlow Rule: Device: atl-003, [IN_PORT{port=120}], [OUTPUT{port=130}]\nAnalysis: Black Hole!\n\nFlow Rule: Device: atl-001, [IN_PORT{port=110}], [OUTPUT{port=90}]\nAnalysis: Cycle Critical Point!\n\nFlow Rule: Device: atl-004, [], [OUTPUT{port=50}]\nAnalysis: Cycle!\n\nFlow Rule: Device: atl-001, [IN_PORT{port=110}], [OUTPUT{port=150}]\nAnalysis: Cleared!\n\nFlow Rule: Device: atl-001, [IN_PORT{port=110}], [OUTPUT{port=100}]\nAnalysis: Black Hole!\n\nFlow Rule: Device: atl-002, [IN_PORT{port=80}], [OUTPUT{port=70}]\nAnalysis: Cycle!\n";
        Assert.assertEquals((String)"Wrong labels", new TreeSet<String>(Arrays.asList(labels.replaceAll("\\s+", "").split("!"))), new TreeSet<String>(Arrays.asList(correctOutput.replaceAll("\\s+", "").split("!"))));
    }

    public FlowRule genFlow(String d, long inPort, long outPort) {
        DeviceId device = DeviceId.deviceId((String)d);
        TrafficSelector ts = DefaultTrafficSelector.builder().matchInPort(PortNumber.portNumber((long)inPort)).build();
        TrafficTreatment tt = DefaultTrafficTreatment.builder().add((Instruction)Instructions.createOutput((PortNumber)PortNumber.portNumber((long)outPort))).build();
        return new DefaultFlowRule(device, ts, tt, 1, (ApplicationId)new DefaultApplicationId(5000, "of"), 50000, true, FlowRuleExtPayLoad.flowRuleExtPayLoad((byte[])new byte[5]));
    }

    public FlowRule genFlow(String d, long outPort) {
        DeviceId device = DeviceId.deviceId((String)d);
        TrafficSelector ts = DefaultTrafficSelector.builder().build();
        TrafficTreatment tt = DefaultTrafficTreatment.builder().add((Instruction)Instructions.createOutput((PortNumber)PortNumber.portNumber((long)outPort))).build();
        return new DefaultFlowRule(device, ts, tt, 1, (ApplicationId)new DefaultApplicationId(5000, "of"), 50000, true, FlowRuleExtPayLoad.flowRuleExtPayLoad((byte[])new byte[5]));
    }
}

