/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowanalyzer;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleServiceAdapter;

public class MockFlowRuleService
extends FlowRuleServiceAdapter {
    final Set<FlowRule> flows = Sets.newHashSet();
    boolean success;
    int errorFlow = -1;

    public void setErrorFlow(int errorFlow) {
        this.errorFlow = errorFlow;
    }

    public void setFuture(boolean success) {
        this.success = success;
    }

    public void apply(FlowRuleOperations ops) {
        AtomicBoolean thisSuccess = new AtomicBoolean(this.success);
        ops.stages().forEach(stage -> stage.forEach(flow -> {
            if ((long)this.errorFlow == flow.rule().id().value()) {
                thisSuccess.set(false);
            } else {
                switch (flow.type()) {
                    case ADD: 
                    case MODIFY: {
                        this.flows.add(flow.rule());
                        break;
                    }
                    case REMOVE: {
                        this.flows.remove(flow.rule());
                        break;
                    }
                }
            }
        }));
        if (thisSuccess.get()) {
            ops.callback().onSuccess(ops);
        } else {
            ops.callback().onError(ops);
        }
    }

    public int getFlowRuleCount() {
        return this.flows.size();
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        return this.flows.stream().filter(flow -> flow.deviceId().equals((Object)deviceId)).map(DefaultFlowEntry::new).collect(Collectors.toList());
    }

    public void applyFlowRules(FlowRule ... flowRules) {
        for (FlowRule flow : flowRules) {
            this.flows.add(flow);
        }
    }

    public void removeFlowRules(FlowRule ... flowRules) {
        for (FlowRule flow : flowRules) {
            this.flows.remove(flow);
        }
    }

    public Iterable<FlowRule> getFlowRulesById(ApplicationId id) {
        return this.flows.stream().filter(flow -> flow.appId() == id.id()).collect(Collectors.toList());
    }

    public Iterable<FlowRule> getFlowRulesByGroupId(ApplicationId appId, short groupId) {
        return this.flows.stream().filter(flow -> flow.appId() == appId.id() && (Integer)flow.groupId().id() == groupId).collect(Collectors.toList());
    }
}

