/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowanalyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onlab.graph.Edge;
import org.onlab.graph.Vertex;
import org.onosproject.flowanalyzer.DefaultMutableTopologyGraph;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyVertex;

public class MockLinkService
extends LinkServiceAdapter {
    DefaultMutableTopologyGraph createdGraph = new DefaultMutableTopologyGraph(new HashSet<TopologyVertex>(), new HashSet<TopologyEdge>());
    List<Link> links = new ArrayList<Link>();

    public int getLinkCount() {
        return this.links.size();
    }

    public Iterable<Link> getLinks() {
        return this.links;
    }

    public Set<Link> getDeviceLinks(DeviceId deviceId) {
        Set<Link> egress = this.getDeviceEgressLinks(deviceId);
        egress.addAll(this.getDeviceIngressLinks(deviceId));
        return egress;
    }

    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        HashSet<Link> setL = new HashSet<Link>();
        for (Link l : this.links) {
            if (!(l.src().elementId() instanceof DeviceId) || !l.src().deviceId().equals((Object)deviceId)) continue;
            setL.add(l);
        }
        return setL;
    }

    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        HashSet<Link> setL = new HashSet<Link>();
        for (Link l : this.links) {
            if (!(l.dst().elementId() instanceof DeviceId) || !l.dst().deviceId().equals((Object)deviceId)) continue;
            setL.add(l);
        }
        return setL;
    }

    public Set<Link> getEgressLinks(ConnectPoint pt) {
        HashSet<Link> setL = new HashSet<Link>();
        for (Link l : this.links) {
            if (!l.src().equals((Object)pt)) continue;
            setL.add(l);
        }
        return setL;
    }

    public Set<Link> getIngressLinks(ConnectPoint pt) {
        HashSet<Link> setL = new HashSet<Link>();
        for (Link l : this.links) {
            if (!l.dst().equals((Object)pt)) continue;
            setL.add(l);
        }
        return setL;
    }

    public Set<Link> getLinks(ConnectPoint pt) {
        HashSet<Link> setL = new HashSet<Link>();
        for (Link l : this.links) {
            if (!l.src().equals((Object)pt) && !l.dst().equals((Object)pt)) continue;
            setL.add(l);
        }
        return setL;
    }

    public void addLink(String device, long port, String device2, long port2) {
        DeviceId d1;
        if (device.charAt(0) == 'H') {
            device = device.substring(1, device.length());
            d1 = HostId.hostId((String)device);
        } else {
            d1 = DeviceId.deviceId((String)device);
        }
        Object d2 = device2.charAt(0) == 'H' ? HostId.hostId((String)device2.substring(1, device2.length())) : DeviceId.deviceId((String)device2);
        ConnectPoint src = new ConnectPoint((ElementId)d1, PortNumber.portNumber((long)port));
        ConnectPoint dst = new ConnectPoint((ElementId)d2, PortNumber.portNumber((long)port2));
        DefaultLink curLink = DefaultLink.builder().src(src).dst(dst).state(Link.State.ACTIVE).build();
        this.links.add((Link)curLink);
        if (d1 instanceof DeviceId && d2 instanceof DeviceId) {
            TopologyVertex v1 = () -> MockLinkService.lambda$addLink$0((ElementId)d1);
            TopologyVertex v2 = () -> MockLinkService.lambda$addLink$1((ElementId)d2);
            this.createdGraph.addVertex((Vertex)v1);
            this.createdGraph.addVertex((Vertex)v2);
            this.createdGraph.addEdge((Edge)new TopologyEdge((Link)curLink, v1, v2){
                final /* synthetic */ Link val$curLink;
                final /* synthetic */ TopologyVertex val$v1;
                final /* synthetic */ TopologyVertex val$v2;
                {
                    this.val$curLink = link;
                    this.val$v1 = topologyVertex;
                    this.val$v2 = topologyVertex2;
                }

                public Link link() {
                    return this.val$curLink;
                }

                public TopologyVertex src() {
                    return this.val$v1;
                }

                public TopologyVertex dst() {
                    return this.val$v2;
                }
            });
        }
    }

    private static /* synthetic */ DeviceId lambda$addLink$1(ElementId d2) {
        return (DeviceId)d2;
    }

    private static /* synthetic */ DeviceId lambda$addLink$0(ElementId d1) {
        return (DeviceId)d1;
    }
}

