/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowanalyzer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyVertex;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={FlowAnalyzer.class})
public class FlowAnalyzer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    TopologyGraph graph;
    Map<FlowEntry, String> label = new HashMap<FlowEntry, String>();
    Set<FlowEntry> ignoredFlows = new HashSet<FlowEntry>();

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public String analyze() {
        this.graph = this.topologyService.getGraph(this.topologyService.currentTopology());
        for (Object v : this.graph.getVertexes()) {
            DeviceId srcDevice = v.deviceId();
            Iterable flowTable = this.flowRuleService.getFlowEntries(srcDevice);
            for (FlowEntry flow : flowTable) {
                this.dfs(flow);
            }
        }
        HashSet<FlowEntry> critpts = new HashSet<FlowEntry>();
        for (FlowEntry flow : this.label.keySet()) {
            if (!"Cycle".equals(this.label.get(flow))) continue;
            Map<FlowEntry, String> labelSaved = this.label;
            this.label = new HashMap<FlowEntry, String>();
            this.ignoredFlows.add(flow);
            for (TopologyVertex v : this.graph.getVertexes()) {
                DeviceId srcDevice = v.deviceId();
                Iterable flowTable = this.flowRuleService.getFlowEntries(srcDevice);
                for (FlowEntry flow1 : flowTable) {
                    this.dfs(flow1);
                }
            }
            boolean replacable = true;
            for (FlowEntry flow2 : this.label.keySet()) {
                if (!"Cleared".equals(labelSaved.get(flow2)) || "Cleared".equals(this.label.get(flow2))) continue;
                replacable = false;
            }
            if (replacable) {
                critpts.add(flow);
            }
            this.label = labelSaved;
        }
        for (FlowEntry flow : critpts) {
            this.label.put(flow, "Cycle Critical Point");
        }
        String s = "\n";
        for (FlowEntry flow : this.label.keySet()) {
            s = s + "Flow Rule: " + this.flowEntryRepresentation(flow) + "\n";
            s = s + "Analysis: " + this.label.get(flow) + "!\n\n";
        }
        s = s + "Analyzed " + this.label.keySet().size() + " flows.";
        return s;
    }

    public Map<FlowEntry, String> calcLabels() {
        this.analyze();
        return this.label;
    }

    public String analysisOutput() {
        this.analyze();
        String s = "\n";
        for (FlowEntry flow : this.label.keySet()) {
            s = s + "Flow Rule: " + this.flowEntryRepresentation(flow) + "\n";
            s = s + "Analysis: " + this.label.get(flow) + "!\n\n";
        }
        return s;
    }

    private boolean dfs(FlowEntry flow) {
        if (this.ignoredFlows.contains(flow)) {
            return false;
        }
        if ("Cycle".equals(this.label.get(flow)) || "Black Hole".equals(this.label.get(flow)) || "Cleared".equals(this.label.get(flow)) || "NA".equals(this.label.get(flow)) || "Cycle Critical Point".equals(this.label.get(flow))) {
            return !"Black Hole".equals(this.label.get(flow));
        }
        if ("Visiting".equals(this.label.get(flow))) {
            this.label.put(flow, "Cycle");
        } else {
            this.label.put(flow, "Visiting");
        }
        boolean pointsToLiveEntry = false;
        List instructions = flow.treatment().allInstructions();
        for (Instruction i : instructions) {
            if (i instanceof Instructions.OutputInstruction) {
                pointsToLiveEntry |= this.analyzeInstruction(i, flow);
            }
            if (!"NA".equals(this.label.get(flow))) continue;
            return pointsToLiveEntry;
        }
        if (!pointsToLiveEntry) {
            this.label.put(flow, "Black Hole");
        } else if ("Visiting".equals(this.label.get(flow))) {
            this.label.put(flow, "Cleared");
        }
        return pointsToLiveEntry;
    }

    private boolean analyzeInstruction(Instruction i, FlowEntry flow) {
        boolean pointsToLiveEntry = false;
        Instructions.OutputInstruction output = (Instructions.OutputInstruction)i;
        PortNumber port = output.port();
        PortNumber outPort = null;
        DeviceId egress = null;
        boolean hasHost = false;
        ConnectPoint portPt = new ConnectPoint((ElementId)flow.deviceId(), port);
        for (Link l : this.linkService.getEgressLinks(portPt)) {
            if (l.dst().elementId() instanceof DeviceId) {
                egress = l.dst().deviceId();
                outPort = l.dst().port();
                continue;
            }
            if (!(l.dst().elementId() instanceof HostId)) continue;
            pointsToLiveEntry = true;
            hasHost = true;
        }
        if (!this.topologyService.isInfrastructure(this.topologyService.currentTopology(), portPt) && egress == null) {
            pointsToLiveEntry = true;
            hasHost = true;
        }
        if (hasHost) {
            return pointsToLiveEntry;
        }
        if (egress == null) {
            this.label.put(flow, "NA");
            return pointsToLiveEntry;
        }
        Iterable dstFlowTable = this.flowRuleService.getFlowEntries(egress);
        Set flowCriteria = flow.selector().criteria();
        HashSet<Criterion> filteredCriteria = new HashSet<Criterion>();
        for (Criterion criterion : flowCriteria) {
            if (criterion instanceof PortCriterion) continue;
            filteredCriteria.add(criterion);
        }
        filteredCriteria.add(Criteria.matchInPort((PortNumber)outPort));
        for (FlowEntry entry : dstFlowTable) {
            if (this.ignoredFlows.contains(entry) || !filteredCriteria.containsAll(entry.selector().criteria())) continue;
            this.dfs(entry);
            if ("Black Hole".equals(this.label.get(entry))) continue;
            pointsToLiveEntry = true;
        }
        return pointsToLiveEntry;
    }

    public String flowEntryRepresentation(FlowEntry flow) {
        return "Device: " + flow.deviceId() + ", " + flow.selector().criteria() + ", " + flow.treatment().immediate();
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }
}

